/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.ProtobufMessageConverter;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;

public class ToProtobufTransformer
extends AbstractTransformer {
    private final ProtobufMessageConverter protobufMessageConverter;

    public ToProtobufTransformer() {
        this(new ProtobufMessageConverter());
    }

    public ToProtobufTransformer(ProtobufMessageConverter protobufMessageConverter) {
        Assert.notNull((Object)protobufMessageConverter, (String)"'protobufMessageConverter' must not be null");
        this.protobufMessageConverter = protobufMessageConverter;
    }

    @Override
    protected Object doTransform(Message<?> message) {
        Assert.isInstanceOf(com.google.protobuf.Message.class, (Object)message.getPayload(), (String)"Payload must be an implementation of 'com.google.protobuf.Message'");
        MessageHeaderAccessor accessor = new MessageHeaderAccessor(message);
        accessor.setHeader("proto_type", (Object)message.getPayload().getClass().getName());
        if (!message.getHeaders().containsKey((Object)"contentType")) {
            accessor.setContentType(ProtobufMessageConverter.PROTOBUF);
        }
        return this.protobufMessageConverter.toMessage(message.getPayload(), accessor.getMessageHeaders());
    }
}

