/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.Serializer;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public final class OptionalSerializers {
    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(Optional.class, new OptionalSerializer(fury));
        fury.registerSerializer(OptionalInt.class, new OptionalIntSerializer(fury));
        fury.registerSerializer(OptionalLong.class, new OptionalLongSerializer(fury));
        fury.registerSerializer(OptionalDouble.class, new OptionalDoubleSerializer(fury));
    }

    public static final class OptionalSerializer
    extends Serializer<Optional> {
        public OptionalSerializer(Fury fury) {
            super(fury, Optional.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Optional value) {
            Object nullable = value.isPresent() ? value.get() : null;
            this.fury.writeRef(buffer, nullable);
        }

        @Override
        public Optional read(MemoryBuffer buffer) {
            return Optional.ofNullable(this.fury.readRef(buffer));
        }
    }

    public static final class OptionalIntSerializer
    extends Serializer<OptionalInt> {
        public OptionalIntSerializer(Fury fury) {
            super(fury, OptionalInt.class);
        }

        @Override
        public void write(MemoryBuffer buffer, OptionalInt value) {
            boolean present = value.isPresent();
            buffer.writeBoolean(present);
            if (present) {
                buffer.writeInt(value.getAsInt());
            }
        }

        @Override
        public OptionalInt read(MemoryBuffer buffer) {
            if (buffer.readBoolean()) {
                return OptionalInt.of(buffer.readInt());
            }
            return OptionalInt.empty();
        }
    }

    public static final class OptionalLongSerializer
    extends Serializer<OptionalLong> {
        public OptionalLongSerializer(Fury fury) {
            super(fury, OptionalLong.class);
        }

        @Override
        public void write(MemoryBuffer buffer, OptionalLong value) {
            boolean present = value.isPresent();
            buffer.writeBoolean(present);
            if (present) {
                buffer.writeLong(value.getAsLong());
            }
        }

        @Override
        public OptionalLong read(MemoryBuffer buffer) {
            if (buffer.readBoolean()) {
                return OptionalLong.of(buffer.readLong());
            }
            return OptionalLong.empty();
        }
    }

    public static final class OptionalDoubleSerializer
    extends Serializer<OptionalDouble> {
        public OptionalDoubleSerializer(Fury fury) {
            super(fury, OptionalDouble.class);
        }

        @Override
        public void write(MemoryBuffer buffer, OptionalDouble value) {
            boolean present = value.isPresent();
            buffer.writeBoolean(present);
            if (present) {
                buffer.writeDouble(value.getAsDouble());
            }
        }

        @Override
        public OptionalDouble read(MemoryBuffer buffer) {
            if (buffer.readBoolean()) {
                return OptionalDouble.of(buffer.readDouble());
            }
            return OptionalDouble.empty();
        }
    }
}

