/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.selector;

import java.util.Objects;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;

public class CacheUpstream
extends CommonUpstream {
    private String cacheType;
    private String url;
    private String password;
    private String database;
    private String master;
    private String mode;
    private int maxIdle;
    private int minIdle;
    private int maxActive;
    private int maxWait;

    public CacheUpstream(Builder builder) {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(String cacheType) {
        this.cacheType = cacheType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getMaster() {
        return this.master;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheUpstream)) {
            return false;
        }
        CacheUpstream that = (CacheUpstream)o;
        return Objects.equals(this.cacheType, that.cacheType) && Objects.equals(this.url, that.url) && Objects.equals(this.getProtocol(), that.getProtocol()) && Objects.equals(this.getUpstreamUrl(), that.getUpstreamUrl()) && Objects.equals(this.isGray(), that.isGray()) && Objects.equals(this.database, that.database);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cacheType, this.url, this.isGray(), this.database);
    }

    @Override
    public String toString() {
        return "CacheUpstream{cacheType='" + this.cacheType + "', url='" + this.url + "', protocol='" + this.getProtocol() + ", upstreamUrl='" + this.getUpstreamUrl() + "', gray=" + this.isGray() + ", database=" + this.database + "'}";
    }

    public static final class Builder {
        private String upstreamHost;
        private String protocol;
        private String upstreamUrl;
        private int weight;
        private boolean statusSet;
        private boolean statusValue;
        private long timestamp;
        private String cacheType;
        private String url;
        private String password;
        private String database;
        private String master;
        private String mode;
        private int maxIdle;
        private int minIdle;
        private int maxActive;
        private int maxWait;

        public CacheUpstream build() {
            return new CacheUpstream(this);
        }

        public Builder upstreamHost(String upstreamHost) {
            this.upstreamHost = upstreamHost;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder upstreamUrl(String upstreamUrl) {
            this.upstreamUrl = upstreamUrl;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder status(boolean status) {
            this.statusValue = status;
            this.statusSet = true;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder cacheType(String cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }
    }
}

