/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.common;

import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreakResult;
import com.tencent.polaris.api.plugin.registry.LocalRegistry;
import com.tencent.polaris.api.plugin.registry.ResourceFilter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pojo.InstanceByProto;
import com.tencent.polaris.client.pojo.Node;
import com.tencent.polaris.client.pojo.ServiceInstancesByProto;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.circuitbreaker.common.StateMachine;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;

public class ChangeStateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeStateUtils.class);

    public static <T extends Verifier> CircuitBreakResult buildCircuitBreakResult(StateMachine<T> stateMachine, Collection<Instance> instances, StateMachine.Parameter parameter) {
        long curTimeMs = System.currentTimeMillis();
        CircuitBreakResult result = new CircuitBreakResult(curTimeMs, parameter.getHalfOpenMaxReqCount());
        String cbName = parameter.getCircuitBreakerName();
        for (Instance instance : instances) {
            Set<StatusDimension> statusDimensions = stateMachine.getStatusDimensions(instance, parameter);
            if (CollectionUtils.isEmpty(statusDimensions)) continue;
            String instanceId = instance.getId();
            for (StatusDimension statusDimension : statusDimensions) {
                if (stateMachine.closeToOpen(instance, statusDimension, parameter)) {
                    result.getInstancesToOpen().put(new CircuitBreakResult.ResultKey(instanceId, statusDimension), instance);
                    LOG.info("circuitBreaker: instance {} and dimension {} changed from close to open by {}", new Object[]{instanceId, statusDimension, cbName});
                    continue;
                }
                if (stateMachine.openToHalfOpen(instance, statusDimension, parameter)) {
                    result.getInstancesToHalfOpen().put(new CircuitBreakResult.ResultKey(instanceId, statusDimension), instance);
                    LOG.info("circuitBreaker: instance {} and dimension {} changed from open to halfOpen by {}", new Object[]{instanceId, statusDimension, cbName});
                    continue;
                }
                if (stateMachine.halfOpenToOpen(instance, statusDimension, parameter)) {
                    result.getInstancesToOpen().put(new CircuitBreakResult.ResultKey(instanceId, statusDimension), instance);
                    LOG.info("circuitBreaker: instance {} and dimension {} changed from halfOpen to open by {}", new Object[]{instanceId, statusDimension, cbName});
                    continue;
                }
                if (!stateMachine.halfOpenToClose(instance, statusDimension, parameter)) continue;
                result.getInstancesToClose().put(new CircuitBreakResult.ResultKey(instanceId, statusDimension), instance);
                LOG.info("circuitBreaker: instance {} and dimension {} changed from halfOpen to close by {}", new Object[]{instanceId, statusDimension, cbName});
            }
        }
        return result;
    }

    public static InstanceByProto getInstance(InstanceGauge instanceGauge, LocalRegistry localRegistry) {
        InstanceByProto instanceByProto;
        ServiceEventKey serviceEventKey = new ServiceEventKey(new ServiceKey(instanceGauge.getNamespace(), instanceGauge.getService()), ServiceEventKey.EventType.INSTANCE);
        ResourceFilter resourceFilter = new ResourceFilter(serviceEventKey, true, true);
        ServiceInstances instances = localRegistry.getInstances(resourceFilter);
        if (!instances.isInitialized()) {
            return null;
        }
        ServiceInstancesByProto serviceInstancesByProto = (ServiceInstancesByProto)instances;
        Instance instance = instanceGauge.getInstance();
        if (instance instanceof InstanceByProto) {
            return (InstanceByProto)instance;
        }
        String instanceId = instanceGauge.getInstanceId();
        if (StringUtils.isNotBlank(instanceId)) {
            instanceByProto = serviceInstancesByProto.getInstance(instanceId);
        } else {
            Node node = new Node(instanceGauge.getHost(), instanceGauge.getPort());
            instanceByProto = serviceInstancesByProto.getInstance(node);
        }
        if (null != instanceByProto) {
            instanceGauge.setInstance(instanceByProto);
        }
        return instanceByProto;
    }

    public static StatusDimension buildStatusDimension(InstanceGauge instanceGauge, StatusDimension.Level level) {
        switch (level) {
            case CALLER_METHOD: {
                return new StatusDimension(instanceGauge.getMethod(), instanceGauge.getCallerService());
            }
            case ALL_CALLER: {
                return new StatusDimension(instanceGauge.getMethod(), null);
            }
            case ALL_METHOD: {
                return new StatusDimension("", instanceGauge.getCallerService());
            }
        }
        return StatusDimension.EMPTY_DIMENSION;
    }
}

