/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.appender.manager;

import com.alipay.common.tracer.core.appender.TraceAppender;
import com.alipay.common.tracer.core.appender.file.TimedRollingFileAppender;
import com.alipay.common.tracer.core.appender.manager.ConsumerThreadFactory;
import com.alipay.common.tracer.core.appender.manager.StringConsumerExceptionHandler;
import com.alipay.common.tracer.core.appender.manager.StringEvent;
import com.alipay.common.tracer.core.appender.manager.StringEventFactory;
import com.alipay.common.tracer.core.appender.self.SynchronizingSelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.disruptor.BlockingWaitStrategy;
import com.alipay.disruptor.EventHandler;
import com.alipay.disruptor.InsufficientCapacityException;
import com.alipay.disruptor.RingBuffer;
import com.alipay.disruptor.WaitStrategy;
import com.alipay.disruptor.dsl.Disruptor;
import com.alipay.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class AsyncCommonAppenderManager {
    private final TraceAppender appender;
    private Disruptor<StringEvent> disruptor;
    private RingBuffer<StringEvent> ringBuffer;
    private final ConsumerThreadFactory threadFactory = new ConsumerThreadFactory();
    private List<Consumer> consumers;
    private static final int DEFAULT_CONSUMER_NUMBER = 1;
    private boolean allowDiscard;
    private boolean isOutDiscardNumber;
    private boolean isOutDiscardId;
    private long discardOutThreshold;
    private PaddedAtomicLong discardCount;
    private static final String DEFAULT_ALLOW_DISCARD = "true";
    private static final String DEFAULT_IS_OUT_DISCARD_NUMBER = "true";
    private static final String DEFAULT_IS_OUT_DISCARD_ID = "false";
    private static final String DEFAULT_DISCARD_OUT_THRESHOLD = "500";

    public AsyncCommonAppenderManager(int queueSize, int consumerNumber, String logName) {
        int realQueueSize = 1 << 32 - Integer.numberOfLeadingZeros(queueSize - 1);
        this.disruptor = new Disruptor<StringEvent>(new StringEventFactory(), realQueueSize, this.threadFactory, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.consumers = new ArrayList<Consumer>(consumerNumber);
        for (int i = 0; i < consumerNumber; ++i) {
            Consumer consumer = new Consumer();
            this.consumers.add(consumer);
            this.disruptor.setDefaultExceptionHandler(new StringConsumerExceptionHandler());
            this.disruptor.handleEventsWith(consumer);
        }
        this.allowDiscard = Boolean.parseBoolean(SofaTracerConfiguration.getProperty("tracer_async_appender_allow_discard", "true"));
        if (this.allowDiscard) {
            this.isOutDiscardNumber = Boolean.parseBoolean(SofaTracerConfiguration.getProperty("tracer_async_appender_is_out_discard_number", "true"));
            this.isOutDiscardId = Boolean.parseBoolean(SofaTracerConfiguration.getProperty("tracer_async_appender_is_out_discard_id", DEFAULT_IS_OUT_DISCARD_ID));
            this.discardOutThreshold = Long.parseLong(SofaTracerConfiguration.getProperty("tracer_async_appender_discard_out_threshold", DEFAULT_DISCARD_OUT_THRESHOLD));
            if (this.isOutDiscardNumber) {
                this.discardCount = new PaddedAtomicLong(0L);
            }
        }
        String globalLogReserveDay = SofaTracerConfiguration.getProperty("tracer_global_log_reserve_day", String.valueOf(7));
        String rollingPolicy = SofaTracerConfiguration.getProperty("tracer_global_rolling_policy");
        if (StringUtils.isBlank(rollingPolicy)) {
            rollingPolicy = "'.'yyyy-MM-dd";
        }
        this.appender = new TimedRollingFileAppender(logName, rollingPolicy, String.valueOf(globalLogReserveDay));
    }

    public AsyncCommonAppenderManager(int queueSize, String logName) {
        this(queueSize, 1, logName);
    }

    public void start(String workerName) {
        this.threadFactory.setWorkName(workerName);
        this.ringBuffer = this.disruptor.start();
    }

    public boolean append(String string) {
        long sequence = 0L;
        if (this.allowDiscard) {
            try {
                sequence = this.ringBuffer.tryNext();
            }
            catch (InsufficientCapacityException e) {
                if (this.isOutDiscardId && string != null) {
                    SynchronizingSelfLog.warn("discarded selflog ");
                }
                if (this.isOutDiscardNumber && this.discardCount.incrementAndGet() == this.discardOutThreshold) {
                    this.discardCount.set(0L);
                    if (this.isOutDiscardNumber) {
                        SynchronizingSelfLog.warn("discarded " + this.discardOutThreshold + " selflogs");
                    }
                }
                return false;
            }
        } else {
            sequence = this.ringBuffer.next();
        }
        try {
            StringEvent event = this.ringBuffer.get(sequence);
            event.setString(string);
        }
        catch (Exception e) {
            SynchronizingSelfLog.error("fail to add event");
            return false;
        }
        this.ringBuffer.publish(sequence);
        return true;
    }

    class PaddedAtomicLong
    extends AtomicLong {
        public volatile long p1;
        public volatile long p2;
        public volatile long p3;
        public volatile long p4;
        public volatile long p5;
        public volatile long p6;

        public PaddedAtomicLong(long initialValue) {
            super(initialValue);
            this.p6 = 7L;
        }

        public PaddedAtomicLong() {
            this.p6 = 7L;
        }
    }

    private class Consumer
    implements EventHandler<StringEvent> {
        private Consumer() {
        }

        @Override
        public void onEvent(StringEvent event, long sequence, boolean endOfBatch) throws Exception {
            String string = event.getString();
            if (string != null) {
                try {
                    AsyncCommonAppenderManager.this.appender.append(string);
                    AsyncCommonAppenderManager.this.appender.flush();
                }
                catch (Exception e) {
                    if (string != null) {
                        SynchronizingSelfLog.error("fail to async write log", e);
                    }
                    SynchronizingSelfLog.error("fail to async write log.And the sofaTracerSpanContext is null", e);
                }
            }
        }
    }
}

