/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.registry;

import com.alipay.common.tracer.core.registry.AbstractTextFormatter;
import com.alipay.common.tracer.core.utils.StringUtils;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class HttpHeadersFormatter
extends AbstractTextFormatter {
    @Override
    public Format<TextMap> getFormatType() {
        return Format.Builtin.HTTP_HEADERS;
    }

    @Override
    protected String encodedValue(String value) {
        if (StringUtils.isBlank(value)) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    @Override
    protected String decodedValue(String value) {
        if (StringUtils.isBlank(value)) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }
}

