/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.samplers;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.samplers.Sampler;
import com.alipay.common.tracer.core.samplers.SamplerProperties;
import com.alipay.common.tracer.core.samplers.SofaTracerPercentageBasedSampler;
import com.alipay.common.tracer.core.utils.StringUtils;

public class SamplerFactory {
    public static SamplerProperties samplerProperties = new SamplerProperties();

    public static Sampler getSampler() throws Exception {
        if (StringUtils.isNotBlank(samplerProperties.getRuleClassName())) {
            return (Sampler)Class.forName(samplerProperties.getRuleClassName()).newInstance();
        }
        return new SofaTracerPercentageBasedSampler(samplerProperties);
    }

    static {
        try {
            float percentage = 100.0f;
            String perStr = SofaTracerConfiguration.getProperty("tracer_sampler_strategy_percentage_key");
            if (StringUtils.isNotBlank(perStr)) {
                percentage = Float.parseFloat(perStr);
            }
            samplerProperties.setPercentage(percentage);
        }
        catch (Exception e) {
            SelfLog.error("It will be use default percentage value :100;", e);
            samplerProperties.setPercentage(100.0f);
        }
        samplerProperties.setRuleClassName(SofaTracerConfiguration.getProperty("tracer_sampler_strategy_custom_rule_class_name"));
    }
}

