/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.support.Util;

public class KeyValue {
    private final io.etcd.jetcd.api.KeyValue kv;
    private final ByteSequence unprefixedKey;
    private final ByteSequence value;

    public KeyValue(io.etcd.jetcd.api.KeyValue kv, ByteSequence namespace) {
        this.kv = kv;
        this.unprefixedKey = ByteSequence.from(kv.getKey().isEmpty() ? kv.getKey() : Util.unprefixNamespace(kv.getKey(), namespace));
        this.value = ByteSequence.from(kv.getValue());
    }

    public ByteSequence getKey() {
        return this.unprefixedKey;
    }

    public ByteSequence getValue() {
        return this.value;
    }

    public long getCreateRevision() {
        return this.kv.getCreateRevision();
    }

    public long getModRevision() {
        return this.kv.getModRevision();
    }

    public long getVersion() {
        return this.kv.getVersion();
    }

    public long getLease() {
        return this.kv.getLease();
    }
}

