/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool;

import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.threadpool.MemoryLimiter;

public class MemoryLimitedLinkedBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = 1374792064759926198L;
    private final MemoryLimiter memoryLimiter;

    public MemoryLimitedLinkedBlockingQueue(Instrumentation inst) {
        this(Integer.MAX_VALUE, inst);
    }

    public MemoryLimitedLinkedBlockingQueue(long memoryLimit, Instrumentation inst) {
        super(Integer.MAX_VALUE);
        this.memoryLimiter = new MemoryLimiter(memoryLimit, inst);
    }

    public MemoryLimitedLinkedBlockingQueue(Collection<? extends E> c, long memoryLimit, Instrumentation inst) {
        super(c);
        this.memoryLimiter = new MemoryLimiter(memoryLimit, inst);
    }

    public void setMemoryLimit(long memoryLimit) {
        this.memoryLimiter.setMemoryLimit(memoryLimit);
    }

    public long getMemoryLimit() {
        return this.memoryLimiter.getMemoryLimit();
    }

    public long getCurrentMemory() {
        return this.memoryLimiter.getCurrentMemory();
    }

    public long getCurrentRemainMemory() {
        return this.memoryLimiter.getCurrentRemainMemory();
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.memoryLimiter.acquireInterruptibly(e);
        super.put(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.memoryLimiter.acquire(e, timeout, unit) && super.offer(e, timeout, unit);
    }

    @Override
    public boolean offer(E e) {
        return this.memoryLimiter.acquire(e) && super.offer(e);
    }

    @Override
    public E take() throws InterruptedException {
        Object e = super.take();
        this.memoryLimiter.releaseInterruptibly(e);
        return e;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object e = super.poll(timeout, unit);
        this.memoryLimiter.releaseInterruptibly(e, timeout, unit);
        return e;
    }

    @Override
    public E poll() {
        Object e = super.poll();
        this.memoryLimiter.release(e);
        return e;
    }

    @Override
    public boolean remove(Object o) {
        boolean success = super.remove(o);
        if (success) {
            this.memoryLimiter.release(o);
        }
        return success;
    }

    @Override
    public void clear() {
        super.clear();
        this.memoryLimiter.clear();
    }
}

