/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import java.util.HashSet;
import java.util.Set;

public class ServicePackagesHolder {
    public static final String BEAN_NAME = "dubboServicePackagesHolder";
    private final Set<String> scannedPackages = new HashSet<String>();
    private final Set<String> scannedClasses = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScannedPackage(String apackage) {
        apackage = this.normalizePackage(apackage);
        Set<String> set = this.scannedPackages;
        synchronized (set) {
            this.scannedPackages.add(apackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPackageScanned(String packageName) {
        packageName = this.normalizePackage(packageName);
        Set<String> set = this.scannedPackages;
        synchronized (set) {
            if (this.scannedPackages.contains(packageName)) {
                return true;
            }
            for (String scannedPackage : this.scannedPackages) {
                if (!this.isSubPackage(packageName, scannedPackage)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScannedClass(String className) {
        Set<String> set = this.scannedClasses;
        synchronized (set) {
            this.scannedClasses.add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClassScanned(String className) {
        Set<String> set = this.scannedClasses;
        synchronized (set) {
            return this.scannedClasses.contains(className);
        }
    }

    private boolean isSubPackage(String testPkg, String parent) {
        return testPkg.startsWith(parent);
    }

    private String normalizePackage(String apackage) {
        if (!apackage.endsWith(".")) {
            apackage = apackage + ".";
        }
        return apackage;
    }
}

