/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.Map;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.directory.AbstractDirectory;
import org.apache.dubbo.rpc.cluster.router.state.StateRouter;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ServiceMetadata;

@Cmd(name="getRouterSnapshot", summary="Get State Router Snapshot.", example={"getRouterSnapshot xx.xx.xxx.service"})
public class GetRouterSnapshot
implements BaseCommand {
    private final FrameworkModel frameworkModel;

    public GetRouterSnapshot(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        if (args.length != 1) {
            return "args count should be 1. example getRouterSnapshot xx.xx.xxx.service";
        }
        String servicePattern = args[0];
        StringBuilder stringBuilder = new StringBuilder();
        for (ConsumerModel consumerModel : this.frameworkModel.getServiceRepository().allConsumerModels()) {
            try {
                Object object;
                ServiceMetadata metadata = consumerModel.getServiceMetadata();
                if (!metadata.getServiceKey().matches(servicePattern) && !metadata.getDisplayServiceKey().matches(servicePattern) || !((object = metadata.getAttribute("currentClusterInvoker")) instanceof Map)) continue;
                Map invokerMap = (Map)object;
                for (Map.Entry invokerEntry : invokerMap.entrySet()) {
                    Directory directory = ((MigrationInvoker)invokerEntry.getValue()).getDirectory();
                    StateRouter headStateRouter = directory.getRouterChain().getHeadStateRouter();
                    stringBuilder.append(metadata.getServiceKey()).append('@').append(Integer.toHexString(System.identityHashCode(metadata))).append("\n").append("[ All Invokers:").append(directory.getAllInvokers().size()).append(" ] ").append("[ Valid Invokers: ").append(((AbstractDirectory)directory).getValidInvokers().size()).append(" ]\n").append("\n").append(headStateRouter.buildSnapshot()).append("\n\n");
                }
            }
            catch (Throwable throwable) {
            }
        }
        return stringBuilder.toString();
    }
}

