/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.reactive;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.dubbo.rpc.protocol.tri.CancelableStreamObserver;
import org.apache.dubbo.rpc.protocol.tri.observer.CallStreamObserver;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AbstractTripleReactorPublisher<T>
extends CancelableStreamObserver<T>
implements Publisher<T>,
Subscription {
    private boolean canRequest;
    private long requested;
    private final AtomicBoolean SUBSCRIBED = new AtomicBoolean();
    private volatile Subscriber<? super T> downstream;
    protected volatile CallStreamObserver<?> subscription;
    private final AtomicBoolean HAS_SUBSCRIPTION = new AtomicBoolean();
    private volatile boolean isCancelled;
    private volatile boolean isDone;
    private volatile Consumer<CallStreamObserver<?>> onSubscribe;
    private volatile Runnable shutdownHook;
    private final AtomicBoolean CALLED_SHUT_DOWN_HOOK = new AtomicBoolean();

    public AbstractTripleReactorPublisher() {
    }

    public AbstractTripleReactorPublisher(Consumer<CallStreamObserver<?>> onSubscribe, Runnable shutdownHook) {
        this.onSubscribe = onSubscribe;
        this.shutdownHook = shutdownHook;
    }

    protected void onSubscribe(CallStreamObserver<?> subscription) {
        if (subscription != null && this.subscription == null && this.HAS_SUBSCRIPTION.compareAndSet(false, true)) {
            this.subscription = subscription;
            subscription.disableAutoFlowControl();
            if (this.onSubscribe != null) {
                this.onSubscribe.accept(subscription);
            }
            return;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " supports only a single subscription");
    }

    @Override
    public void onNext(T data) {
        if (this.isDone || this.isCancelled) {
            return;
        }
        this.downstream.onNext(data);
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.isDone || this.isCancelled) {
            return;
        }
        this.isDone = true;
        this.downstream.onError(throwable);
        this.doPostShutdown();
    }

    @Override
    public void onCompleted() {
        if (this.isDone || this.isCancelled) {
            return;
        }
        this.isDone = true;
        this.downstream.onComplete();
        this.doPostShutdown();
    }

    private void doPostShutdown() {
        Runnable r = this.shutdownHook;
        if (r != null && this.CALLED_SHUT_DOWN_HOOK.compareAndSet(false, true)) {
            this.shutdownHook = null;
            r.run();
        }
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        if (this.SUBSCRIBED.compareAndSet(false, true)) {
            subscriber.onSubscribe((Subscription)this);
            this.downstream = subscriber;
            if (this.isCancelled) {
                this.downstream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long l) {
        AbstractTripleReactorPublisher abstractTripleReactorPublisher = this;
        synchronized (abstractTripleReactorPublisher) {
            if (this.SUBSCRIBED.get() && this.canRequest) {
                this.subscription.request(l >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l);
            } else {
                this.requested += l;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRequest() {
        AbstractTripleReactorPublisher abstractTripleReactorPublisher = this;
        synchronized (abstractTripleReactorPublisher) {
            if (!this.canRequest) {
                this.canRequest = true;
                long count = this.requested;
                this.subscription.request(count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count);
            }
        }
    }

    public void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        this.doPostShutdown();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }
}

