/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.state;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.Node;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.router.state.BitList;

public class RouterGroupingState<T> {
    private final String routerName;
    private final int total;
    private final Map<String, BitList<Invoker<T>>> grouping;

    public RouterGroupingState(String routerName, int total, Map<String, BitList<Invoker<T>>> grouping) {
        this.routerName = routerName;
        this.total = total;
        this.grouping = grouping;
    }

    public String getRouterName() {
        return this.routerName;
    }

    public int getTotal() {
        return this.total;
    }

    public Map<String, BitList<Invoker<T>>> getGrouping() {
        return this.grouping;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.routerName).append(' ').append(" Total: ").append(this.total).append("\n");
        for (Map.Entry<String, BitList<Invoker<T>>> entry : this.grouping.entrySet()) {
            BitList<Invoker<T>> invokers = entry.getValue();
            stringBuilder.append("[ ").append(entry.getKey()).append(" -> ").append(invokers.isEmpty() ? "Empty" : invokers.stream().limit(5L).map(Node::getUrl).map(URL::getAddress).collect(Collectors.joining(","))).append(invokers.size() > 5 ? "..." : "").append(" (Total: ").append(invokers.size()).append(") ]").append("\n");
        }
        return stringBuilder.toString();
    }
}

