/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcStatus;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"provider"}, value={"executes"})
public class ExecuteLimitFilter
implements Filter,
BaseFilter.Listener {
    private static final String EXECUTE_LIMIT_FILTER_START_TIME = "execute_limit_filter_start_time";

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        int max;
        String methodName;
        URL url = invoker.getUrl();
        if (!RpcStatus.beginCount(url, methodName = RpcUtils.getMethodName(invocation), max = url.getMethodParameter(methodName, "executes", 0))) {
            throw new RpcException(7, "Failed to invoke method " + RpcUtils.getMethodName(invocation) + " in provider " + url + ", cause: The service using threads greater than <dubbo:service executes=\"" + max + "\" /> limited.");
        }
        invocation.put(EXECUTE_LIMIT_FILTER_START_TIME, System.currentTimeMillis());
        try {
            return invoker.invoke(invocation);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RpcException("unexpected exception when ExecuteLimitFilter", t);
        }
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        RpcStatus.endCount(invoker.getUrl(), this.getRealMethodName(invoker, invocation), this.getElapsed(invocation), true);
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        RpcException rpcException;
        if (t instanceof RpcException && (rpcException = (RpcException)t).isLimitExceed()) {
            return;
        }
        RpcStatus.endCount(invoker.getUrl(), this.getRealMethodName(invoker, invocation), this.getElapsed(invocation), false);
    }

    private String getRealMethodName(Invoker<?> invoker, Invocation invocation) {
        if ((invocation.getMethodName().equals("$invoke") || invocation.getMethodName().equals("$invokeAsync")) && invocation.getArguments() != null && invocation.getArguments().length == 3 && !GenericService.class.isAssignableFrom(invoker.getInterface())) {
            return ((String)invocation.getArguments()[0]).trim();
        }
        return invocation.getMethodName();
    }

    private long getElapsed(Invocation invocation) {
        Object beginTime = invocation.get(EXECUTE_LIMIT_FILTER_START_TIME);
        return beginTime != null ? System.currentTimeMillis() - (Long)beginTime : 0L;
    }
}

