/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.aft.impl;

import com.alipay.sofa.rpc.client.aft.InvocationStat;
import com.alipay.sofa.rpc.client.aft.InvocationStatDimension;
import com.alipay.sofa.rpc.client.aft.impl.ServiceExceptionInvocationStat;
import com.alipay.sofa.rpc.common.utils.CalculateUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractInvocationStat
implements InvocationStat {
    protected final InvocationStatDimension dimension;
    protected final AtomicLong invokeCount = new AtomicLong(0L);
    protected final AtomicLong exceptionCount = new AtomicLong(0L);
    private final transient AtomicInteger uselessCycle = new AtomicInteger(0);

    public AbstractInvocationStat(InvocationStatDimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public InvocationStatDimension getDimension() {
        return this.dimension;
    }

    @Override
    public AtomicInteger getUselessCycle() {
        return this.uselessCycle;
    }

    @Override
    public long invoke() {
        return this.invokeCount.incrementAndGet();
    }

    @Override
    public long getInvokeCount() {
        return this.invokeCount.get();
    }

    @Override
    public double getExceptionRate() {
        long invokeCount = this.getInvokeCount();
        return invokeCount == 0L ? -1.0 : CalculateUtils.divide(this.getExceptionCount(), invokeCount);
    }

    @Override
    public long getExceptionCount() {
        return this.exceptionCount.get();
    }

    protected void setInvokeCount(long count) {
        this.invokeCount.set(count);
    }

    public void setExceptionCount(long count) {
        this.exceptionCount.set(count);
    }

    @Override
    public InvocationStat snapshot() {
        ServiceExceptionInvocationStat invocationStat = new ServiceExceptionInvocationStat(this.dimension);
        invocationStat.setInvokeCount(this.getInvokeCount());
        invocationStat.setExceptionCount(this.getExceptionCount());
        return invocationStat;
    }

    @Override
    public void update(InvocationStat snapshot) {
        this.invokeCount.addAndGet(-snapshot.getInvokeCount());
        this.exceptionCount.addAndGet(-snapshot.getExceptionCount());
    }
}

