/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.polaris;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRunningState;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.event.ConsumerSubEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ProviderPubEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.polaris.PolarisRegistryProperties;
import com.alipay.sofa.rpc.registry.polaris.PolarisWatcher;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceHeartbeatRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.factory.api.DiscoveryAPIFactory;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Extension(value="polaris")
public class PolarisRegistry
extends Registry {
    public static final String EXT_NAME = "PolarisRegistry";
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisRegistry.class);
    private final PolarisRegistryProperties properties;
    public ProviderAPI providerAPI;
    public ConsumerAPI consumerAPI;
    private ScheduledExecutorService heartbeatExecutor;
    private Map<String, ScheduledFuture> heartbeatFutures = new ConcurrentHashMap<String, ScheduledFuture>();
    private Map<String, PolarisWatcher> polarisWatchers = new ConcurrentHashMap<String, PolarisWatcher>();

    protected PolarisRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
        this.properties = new PolarisRegistryProperties(registryConfig.getParameters());
    }

    public static String buildServiceName(AbstractInterfaceConfig config) {
        return ConfigUniqueNameGenerator.getUniqueName(config);
    }

    @Override
    public void init() {
        if (this.providerAPI != null) {
            return;
        }
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setDefault();
        ServerConnectorConfigImpl serverConnector = configuration.getGlobal().getServerConnector();
        serverConnector.setAddresses(Arrays.asList(this.registryConfig.getAddress()));
        serverConnector.setConnectTimeout(Long.valueOf(this.registryConfig.getConnectTimeout()));
        serverConnector.setProtocol(this.properties.getConnectorProtocol());
        this.providerAPI = DiscoveryAPIFactory.createProviderAPIByConfig((Configuration)configuration);
        this.consumerAPI = DiscoveryAPIFactory.createConsumerAPIByConfig((Configuration)configuration);
        int coreSize = this.properties.getHeartbeatCoreSize();
        this.heartbeatExecutor = Executors.newScheduledThreadPool(coreSize);
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void register(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return;
        }
        if (!config.isRegister()) {
            return;
        }
        try {
            List<InstanceRegisterRequest> services = this.buildPolarisRegister(config);
            if (CommonUtils.isNotEmpty(services)) {
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010000003", config.getInterfaceId()));
                }
                for (InstanceRegisterRequest service : services) {
                    this.registerPolarisService(config, service);
                    if (!LOGGER.isInfoEnabled(appName)) continue;
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010000001", config.getInterfaceId()));
                }
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010000004", config.getInterfaceId()));
                }
            }
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010060007", "polarisRegistry", config.buildKey()), e);
        }
        if (EventBus.isEnable(ProviderPubEvent.class)) {
            ProviderPubEvent event = new ProviderPubEvent(config);
            EventBus.post(event);
        }
    }

    public List<InstanceRegisterRequest> buildPolarisRegister(ProviderConfig config) {
        List<ServerConfig> serverConfigs = config.getServer();
        if (CommonUtils.isEmpty(serverConfigs)) {
            return Collections.emptyList();
        }
        ArrayList<InstanceRegisterRequest> requestList = new ArrayList<InstanceRegisterRequest>();
        for (ServerConfig serverConfig : serverConfigs) {
            InstanceRegisterRequest request = new InstanceRegisterRequest();
            request.setNamespace(this.buildNameSpace(config.getAppName()));
            request.setService(PolarisRegistry.buildServiceName(config));
            request.setHost(RegistryUtils.getServerHost(serverConfig));
            request.setPort(Integer.valueOf(serverConfig.getPort()));
            request.setPriority(Integer.valueOf(config.getPriority()));
            request.setProtocol(serverConfig.getProtocol());
            request.setWeight(Integer.valueOf(config.getWeight()));
            request.setTimeoutMs((long)config.getTimeout());
            request.setVersion(config.getVersion());
            request.setTtl(Integer.valueOf(this.properties.getHealthCheckTTL()));
            Map<String, String> metaData = RegistryUtils.convertProviderToMap(config, serverConfig);
            this.checkAndDelNull(metaData);
            request.setMetadata(metaData);
            requestList.add(request);
        }
        return requestList;
    }

    private String buildNameSpace(String appName) {
        return null == appName ? "sofa-default" : appName;
    }

    private void checkAndDelNull(Map<String, String> metaData) {
        metaData.entrySet().removeIf(e -> e.getValue() == null);
    }

    private void registerPolarisService(ProviderConfig config, InstanceRegisterRequest service) {
        this.providerAPI.register(service);
        if (service.getTtl() != null) {
            ScheduledFuture<?> scheduledFuture = this.heartbeatExecutor.scheduleAtFixedRate(() -> this.heartbeatPolaris(service), 0L, this.properties.getHeartbeatInterval(), TimeUnit.MILLISECONDS);
            ScheduledFuture<?> oldFuture = this.heartbeatFutures.put(RegistryUtils.buildUniqueName(config, service.getProtocol()), scheduledFuture);
            if (oldFuture != null) {
                oldFuture.cancel(true);
            }
        }
    }

    private void heartbeatPolaris(InstanceRegisterRequest service) {
        try {
            InstanceHeartbeatRequest instanceHeartbeatRequest = new InstanceHeartbeatRequest();
            instanceHeartbeatRequest.setNamespace(service.getNamespace());
            instanceHeartbeatRequest.setService(service.getService());
            instanceHeartbeatRequest.setHost(service.getHost());
            instanceHeartbeatRequest.setPort(service.getPort());
            this.providerAPI.heartbeat(instanceHeartbeatRequest);
        }
        catch (Exception e) {
            LOGGER.error(LogCodes.getLog("010060024", "Polaris"), e);
        }
    }

    @Override
    public void unRegister(ProviderConfig config) {
        block7: {
            String appName = config.getAppName();
            if (!this.registryConfig.isRegister()) {
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
                }
                return;
            }
            if (!config.isRegister()) {
                return;
            }
            try {
                List<InstanceRegisterRequest> instanceRegisterRequests = this.buildPolarisRegister(config);
                for (InstanceRegisterRequest request : instanceRegisterRequests) {
                    this.deregisterPolarisService(config, request);
                }
            }
            catch (Exception e) {
                if (RpcRunningState.isShuttingDown()) break block7;
                if (e instanceof SofaRpcRuntimeException) {
                    throw e;
                }
                throw new SofaRpcRuntimeException(LogCodes.getLog("010060008", EXT_NAME), e);
            }
        }
    }

    private void deregisterPolarisService(ProviderConfig config, InstanceRegisterRequest request) {
        InstanceDeregisterRequest instanceDeregisterRequest = new InstanceDeregisterRequest();
        instanceDeregisterRequest.setNamespace(request.getNamespace());
        instanceDeregisterRequest.setService(request.getService());
        instanceDeregisterRequest.setHost(request.getHost());
        instanceDeregisterRequest.setPort(request.getPort());
        this.providerAPI.deRegister(instanceDeregisterRequest);
        ScheduledFuture future = this.heartbeatFutures.remove(RegistryUtils.buildUniqueName(config, request.getProtocol()));
        if (future != null) {
            future.cancel(true);
        }
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        for (ProviderConfig config : configs) {
            this.unRegister(config);
        }
    }

    @Override
    public List<ProviderGroup> subscribe(ConsumerConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isSubscribe()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return null;
        }
        if (!config.isSubscribe()) {
            return null;
        }
        try {
            List<ProviderInfo> providers = this.findService(config);
            if (EventBus.isEnable(ConsumerSubEvent.class)) {
                ConsumerSubEvent event = new ConsumerSubEvent(config);
                EventBus.post(event);
            }
            return Collections.singletonList(new ProviderGroup().addAll(providers));
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010060009", EXT_NAME), e);
        }
    }

    private List<ProviderInfo> findService(ConsumerConfig config) {
        String uniqueName = RegistryUtils.buildUniqueName(config, config.getProtocol());
        PolarisWatcher polarisWatcher = this.polarisWatchers.computeIfAbsent(uniqueName, key -> {
            PolarisWatcher watcher = new PolarisWatcher(this.buildNameSpace(config.getAppName()), PolarisRegistry.buildServiceName(config), config.getProtocol(), this.consumerAPI, this.properties);
            watcher.init();
            return watcher;
        });
        polarisWatcher.addListener(config.getProviderInfoListener());
        return polarisWatcher.currentProviders();
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isSubscribe() && LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(config.getAppName(), LogCodes.getLog("010060003"));
        }
        if (!config.isSubscribe()) {
            return;
        }
        String uniqueName = RegistryUtils.buildUniqueName(config, config.getProtocol());
        PolarisWatcher informer = this.polarisWatchers.get(uniqueName);
        if (informer == null) {
            return;
        }
        informer.removeListener(config.getProviderInfoListener());
        if (informer.getListenerSize() == 0) {
            this.polarisWatchers.remove(uniqueName);
            informer.shutdown();
        }
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig config : configs) {
            this.unSubscribe(config);
        }
    }

    @Override
    public void destroy() {
        if (this.heartbeatExecutor != null) {
            this.heartbeatExecutor.shutdown();
        }
        for (PolarisWatcher watcher : this.polarisWatchers.values()) {
            watcher.shutdown();
        }
        if (this.providerAPI != null) {
            this.providerAPI.destroy();
        }
        if (this.consumerAPI != null) {
            this.consumerAPI.destroy();
        }
    }
}

