/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.tracer;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.tracer.Tracer;
import com.alipay.sofa.rpc.tracer.TracerFactory;

public final class Tracers {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tracers.class);
    private static boolean openTrace = false;
    private static Tracer tracer;

    public static Tracer getTracer() {
        return tracer;
    }

    public static boolean isEnable() {
        return openTrace;
    }

    public static void startRpc(SofaRequest request) {
        block3: {
            if (openTrace) {
                try {
                    tracer.startRpc(request);
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("", e);
                }
            }
        }
    }

    public static void clientBeforeSend(SofaRequest request) {
        block3: {
            if (openTrace) {
                try {
                    tracer.clientBeforeSend(request);
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    public static void serverReceived(SofaRequest request) {
        block3: {
            if (openTrace) {
                try {
                    tracer.serverReceived(request);
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    public static void serverSend(SofaRequest request, SofaResponse response, Throwable throwable) {
        block3: {
            if (openTrace) {
                try {
                    tracer.serverSend(request, response, throwable);
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    public static void clientReceived(SofaRequest request, SofaResponse response, Throwable throwable) {
        block3: {
            if (openTrace) {
                try {
                    tracer.clientReceived(request, response, throwable);
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    public static void clientAsyncAfterSend(SofaRequest request) {
        block3: {
            if (openTrace) {
                try {
                    tracer.clientAsyncAfterSend(request);
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    public static void clientAsyncReceivedPrepare() {
        block3: {
            if (openTrace) {
                try {
                    tracer.clientAsyncReceivedPrepare();
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    public static void profile(String profileApp, String code, String message) {
        block3: {
            if (openTrace) {
                try {
                    tracer.profile(profileApp, code, message);
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    public static void checkState() {
        block3: {
            if (openTrace) {
                try {
                    tracer.checkState();
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    static {
        try {
            String traceName = RpcConfigs.getStringValue("default.tracer");
            if (StringUtils.isNotBlank(traceName)) {
                tracer = TracerFactory.getTracer(traceName);
                openTrace = true;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Load tracer impl success: {}, {}", traceName, tracer);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(LogCodes.getLog("010030002"), e);
        }
    }
}

