/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.rest;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.cache.ReflectCache;
import com.alipay.sofa.rpc.common.utils.ClassTypeUtils;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.transport.AbstractProxyClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.rest.SofaResteasyClientBuilder;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

@Extension(value="rest")
public class RestClientTransport
extends AbstractProxyClientTransport {
    private static final int MIN_CONNECTION_POOL_SIZE = 80;

    public RestClientTransport(ClientTransportConfig transportConfig) {
        super(transportConfig);
    }

    @Override
    protected Object buildProxy(ClientTransportConfig transportConfig) throws SofaRpcException {
        SofaResteasyClientBuilder builder = new SofaResteasyClientBuilder();
        ResteasyClient client = builder.registerProvider().logProviders().establishConnectionTimeout(transportConfig.getConnectTimeout(), TimeUnit.MILLISECONDS).socketTimeout((long)transportConfig.getInvokeTimeout(), TimeUnit.MILLISECONDS).connectionPoolSize(Math.max(transportConfig.getConnectionNum(), 80)).build();
        ProviderInfo provider = transportConfig.getProviderInfo();
        String url = "http://" + provider.getHost() + ":" + provider.getPort() + "/" + StringUtils.trimToEmpty(provider.getPath());
        ResteasyWebTarget target = client.target(url);
        return target.proxy(ClassUtils.forName(transportConfig.getConsumerConfig().getInterfaceId()));
    }

    @Override
    protected Method getMethod(SofaRequest request) throws SofaRpcException {
        String[] methodSigns;
        String methodName;
        String serviceUniqueName = request.getTargetServiceUniqueName();
        Method method = ReflectCache.getOverloadMethodCache(serviceUniqueName, methodName = request.getMethodName(), methodSigns = request.getMethodArgSigs());
        if (method == null) {
            try {
                String interfaceName = request.getInterfaceName();
                method = ClassUtils.forName(interfaceName).getMethod(methodName, ClassTypeUtils.getClasses(methodSigns));
                ReflectCache.putOverloadMethodCache(serviceUniqueName, method);
            }
            catch (NoSuchMethodException e) {
                throw new SofaRpcException(299, "Method not found", e);
            }
        }
        return method;
    }
}

