/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.session;

import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.session.SessionsDescriptor;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.util.Assert;

@Endpoint(id="sessions")
public class SessionsEndpoint {
    private final SessionRepository<? extends Session> sessionRepository;
    private final FindByIndexNameSessionRepository<? extends Session> indexedSessionRepository;

    @Deprecated(since="3.3.0", forRemoval=true)
    public SessionsEndpoint(FindByIndexNameSessionRepository<? extends Session> sessionRepository) {
        this((SessionRepository<? extends Session>)sessionRepository, sessionRepository);
    }

    public SessionsEndpoint(SessionRepository<? extends Session> sessionRepository, FindByIndexNameSessionRepository<? extends Session> indexedSessionRepository) {
        Assert.notNull(sessionRepository, (String)"SessionRepository must not be null");
        this.sessionRepository = sessionRepository;
        this.indexedSessionRepository = indexedSessionRepository;
    }

    @ReadOperation
    public SessionsDescriptor sessionsForUsername(String username) {
        if (this.indexedSessionRepository == null) {
            return null;
        }
        Map sessions = this.indexedSessionRepository.findByPrincipalName(username);
        return new SessionsDescriptor(sessions);
    }

    @ReadOperation
    public SessionsDescriptor.SessionDescriptor getSession(@Selector String sessionId) {
        Session session = this.sessionRepository.findById(sessionId);
        if (session == null) {
            return null;
        }
        return new SessionsDescriptor.SessionDescriptor(session);
    }

    @DeleteOperation
    public void deleteSession(@Selector String sessionId) {
        this.sessionRepository.deleteById(sessionId);
    }
}

