/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.reactor.AbstractSubscriber;
import reactor.core.CoreSubscriber;

class RateLimiterSubscriber<T>
extends AbstractSubscriber<T> {
    private final RateLimiter rateLimiter;

    protected RateLimiterSubscriber(RateLimiter rateLimiter, CoreSubscriber<? super T> downstreamSubscriber) {
        super(downstreamSubscriber);
        this.rateLimiter = rateLimiter;
    }

    public void hookOnNext(T value) {
        if (!this.isDisposed()) {
            this.rateLimiter.onResult(value);
            this.downstreamSubscriber.onNext(value);
        }
    }

    public void hookOnError(Throwable t) {
        this.rateLimiter.onError(t);
        this.downstreamSubscriber.onError(t);
    }

    public void hookOnComplete() {
        this.downstreamSubscriber.onComplete();
    }
}

