/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.KeySupplier;
import java.security.Key;
import java.security.Provider;

public class ProviderKey<T extends Key>
implements Key,
KeySupplier<T> {
    private final T key;
    private final Provider provider;

    public static Provider getProvider(Key key, Provider backup) {
        if (key instanceof ProviderKey) {
            ProviderKey pkey = (ProviderKey)key;
            return (Provider)Assert.stateNotNull((Object)pkey.getProvider(), (String)"ProviderKey provider can never be null.");
        }
        return backup;
    }

    public static <K extends Key> K getKey(K key) {
        return (K)(key instanceof ProviderKey ? ((ProviderKey)key).getKey() : key);
    }

    ProviderKey(Provider provider, T key) {
        this.provider = (Provider)Assert.notNull((Object)provider, (String)"Provider cannot be null.");
        this.key = (Key)Assert.notNull(key, (String)"Key argument cannot be null.");
        if (key instanceof ProviderKey) {
            String msg = "Nesting not permitted.";
            throw new IllegalArgumentException(msg);
        }
    }

    public T getKey() {
        return this.key;
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.key.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.key.getEncoded();
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

