/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread;

import com.alipay.sofa.common.thread.SofaThreadPoolExecutor;
import com.alipay.sofa.common.utils.ClassUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class SofaThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    public static final String SIMPLE_CLASS_NAME = SofaThreadPoolTaskExecutor.class.getSimpleName();
    protected SofaThreadPoolExecutor sofaThreadPoolExecutor;
    protected String threadPoolName;
    protected String spaceName;
    protected long taskTimeout;
    protected long period;
    protected boolean sofaTracerTransmit;

    protected ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        Integer queueCapacity = (Integer)ClassUtil.getField("queueCapacity", (Object)this);
        final TaskDecorator taskDecorator = (TaskDecorator)ClassUtil.getField("taskDecorator", (Object)this);
        BlockingQueue queue = this.createQueue(queueCapacity);
        if (this.threadPoolName == null) {
            this.threadPoolName = this.createName();
        }
        SofaThreadPoolExecutor executor = taskDecorator != null ? new SofaThreadPoolExecutor(this.getCorePoolSize(), this.getMaxPoolSize(), this.getKeepAliveSeconds(), TimeUnit.SECONDS, queue, threadFactory, rejectedExecutionHandler, this.threadPoolName, this.spaceName, this.taskTimeout, this.period, TimeUnit.MILLISECONDS){

            @Override
            public void execute(Runnable command) {
                super.execute(taskDecorator.decorate(command));
            }
        } : new SofaThreadPoolExecutor(this.getCorePoolSize(), this.getMaxPoolSize(), this.getKeepAliveSeconds(), TimeUnit.SECONDS, queue, threadFactory, rejectedExecutionHandler, this.threadPoolName, this.spaceName, this.taskTimeout, this.period, TimeUnit.MILLISECONDS);
        executor.setSofaTracerTransmit(this.sofaTracerTransmit);
        Boolean allowCoreThreadTimeOut = (Boolean)ClassUtil.getField("allowCoreThreadTimeOut", (Object)this);
        if (allowCoreThreadTimeOut.booleanValue()) {
            executor.allowCoreThreadTimeOut(true);
        }
        ClassUtil.setField("threadPoolExecutor", (Object)this, executor);
        this.sofaThreadPoolExecutor = executor;
        return executor;
    }

    protected String createName() {
        return SIMPLE_CLASS_NAME + String.format("%08x", ((Object)((Object)this)).hashCode());
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
        if (this.sofaThreadPoolExecutor != null) {
            this.sofaThreadPoolExecutor.updateThreadPoolName(threadPoolName);
        }
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
        if (this.sofaThreadPoolExecutor != null) {
            this.sofaThreadPoolExecutor.updateSpaceName(spaceName);
        }
    }

    public long getTaskTimeout() {
        if (this.sofaThreadPoolExecutor == null) {
            return 0L;
        }
        return this.sofaThreadPoolExecutor.getConfig().getTaskTimeout();
    }

    public void setTaskTimeout(long taskTimeout) {
        this.taskTimeout = taskTimeout;
        if (this.sofaThreadPoolExecutor != null) {
            this.sofaThreadPoolExecutor.updateTaskTimeout(taskTimeout);
        }
    }

    public long getPeriod() {
        if (this.sofaThreadPoolExecutor == null) {
            return 0L;
        }
        return this.sofaThreadPoolExecutor.getConfig().getPeriod();
    }

    public void setPeriod(long period) {
        this.period = period;
        if (this.sofaThreadPoolExecutor != null) {
            this.sofaThreadPoolExecutor.updatePeriod(period);
        }
    }

    public TimeUnit getTimeUnit() {
        if (this.sofaThreadPoolExecutor == null) {
            return TimeUnit.MILLISECONDS;
        }
        return this.sofaThreadPoolExecutor.getConfig().getTimeUnit();
    }

    public boolean isSofaTracerTransmit() {
        return this.sofaTracerTransmit;
    }

    public void setSofaTracerTransmit(boolean sofaTracerTransmit) {
        this.sofaTracerTransmit = sofaTracerTransmit;
    }
}

