/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicStringProperty;
import java.util.IdentityHashMap;

public abstract class PropertyWrapper<V> {
    protected DynamicProperty prop;
    protected V defaultValue;
    private static final IdentityHashMap<Class<? extends PropertyWrapper<?>>, Object> SUBCLASSES_WITH_NO_CALLBACK = new IdentityHashMap();
    private static final Object DUMMY_VALUE;

    public static final void registerSubClassWithNoCallback(Class<? extends PropertyWrapper<?>> clazz) {
        SUBCLASSES_WITH_NO_CALLBACK.put(clazz, DUMMY_VALUE);
    }

    protected PropertyWrapper(String string, V v) {
        this.prop = DynamicProperty.getInstance(string);
        this.defaultValue = v;
        Class<?> clazz = this.getClass();
        if (!SUBCLASSES_WITH_NO_CALLBACK.containsKey(clazz)) {
            this.prop.addCallback(new Runnable(){

                @Override
                public void run() {
                    PropertyWrapper.this.propertyChanged();
                }
            });
        }
    }

    public String getName() {
        return this.prop.getName();
    }

    protected void propertyChanged() {
    }

    public long getChangedTimestamp() {
        return this.prop.getChangedTimestamp();
    }

    public void addCallback(Runnable runnable) {
        if (runnable != null) {
            this.prop.addCallback(runnable);
        }
    }

    public abstract V getValue();

    public String toString() {
        return "DynamicProperty: {name=" + this.prop.getName() + ", current value=" + this.prop.getString(this.defaultValue.toString()) + "}";
    }

    static {
        PropertyWrapper.registerSubClassWithNoCallback(DynamicIntProperty.class);
        PropertyWrapper.registerSubClassWithNoCallback(DynamicStringProperty.class);
        PropertyWrapper.registerSubClassWithNoCallback(DynamicBooleanProperty.class);
        PropertyWrapper.registerSubClassWithNoCallback(DynamicFloatProperty.class);
        PropertyWrapper.registerSubClassWithNoCallback(DynamicLongProperty.class);
        PropertyWrapper.registerSubClassWithNoCallback(DynamicDoubleProperty.class);
        DUMMY_VALUE = new Object();
    }
}

