/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.utils;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shenyu.common.utils.GsonUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class HttpParamConverter {
    private static final Pattern PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");

    public static String ofString(Supplier<String> supplier) {
        return GsonUtils.getInstance().toJson(HttpParamConverter.initQueryParams(supplier.get()));
    }

    public static <K, V> String toMap(Supplier<MultiValueMap<K, V>> supplier) {
        return GsonUtils.getInstance().toJson((Object)supplier.get().toSingleValueMap());
    }

    public static Map<String, String> initQueryParams(String query) {
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        if (StringUtils.hasLength((String)query)) {
            Matcher matcher = PATTERN.matcher(query);
            while (matcher.find()) {
                String name = HttpParamConverter.decodeQueryParam(matcher.group(1));
                String eq = matcher.group(2);
                String value = matcher.group(3);
                value = StringUtils.hasLength((String)value) ? HttpParamConverter.decodeQueryParam(value) : (StringUtils.hasLength((String)eq) ? "" : null);
                queryParams.put(name, value);
            }
        }
        return queryParams;
    }

    public static String decodeQueryParam(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }
}

