/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sync.data.websocket.handler;

import java.util.List;
import java.util.Objects;
import org.apache.shenyu.common.dto.ProxyApiKeyData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.sync.data.websocket.handler.AbstractDataHandler;
import org.apache.shenyu.sync.data.api.AiProxyApiKeyDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiProxyApiKeyDataHandler
extends AbstractDataHandler<ProxyApiKeyData> {
    private static final Logger LOG = LoggerFactory.getLogger(AiProxyApiKeyDataHandler.class);
    private final List<AiProxyApiKeyDataSubscriber> subscribers;

    public AiProxyApiKeyDataHandler(List<AiProxyApiKeyDataSubscriber> subscribers) {
        this.subscribers = subscribers;
    }

    @Override
    protected List<ProxyApiKeyData> convert(String json) {
        return GsonUtils.getInstance().fromList(json, ProxyApiKeyData.class);
    }

    @Override
    protected void doRefresh(List<ProxyApiKeyData> dataList) {
        LOG.info("[AiProxySync] DataHandler REFRESH, subscribers={}, items={}", (Object)(Objects.isNull(this.subscribers) ? 0 : this.subscribers.size()), (Object)(Objects.isNull(dataList) ? 0 : dataList.size()));
        if (Objects.nonNull(this.subscribers)) {
            for (AiProxyApiKeyDataSubscriber s : this.subscribers) {
                s.refresh();
            }
        }
        this.doUpdate(dataList);
    }

    @Override
    protected void doUpdate(List<ProxyApiKeyData> dataList) {
        if (Objects.isNull(dataList) || Objects.isNull(this.subscribers)) {
            return;
        }
        LOG.info("[AiProxySync] DataHandler UPDATE, subscribers={}, items={}", (Object)this.subscribers.size(), (Object)dataList.size());
        for (ProxyApiKeyData data : dataList) {
            LOG.info("[AiProxySync] onSubscribe proxyKey={}, enabled={}", (Object)(Objects.isNull(data) ? null : data.getProxyApiKey()), (Object)(Objects.isNull(data) ? null : data.getEnabled()));
            for (AiProxyApiKeyDataSubscriber s : this.subscribers) {
                s.onSubscribe(data);
            }
        }
    }

    @Override
    protected void doDelete(List<ProxyApiKeyData> dataList) {
        if (Objects.isNull(dataList) || Objects.isNull(this.subscribers)) {
            return;
        }
        for (ProxyApiKeyData data : dataList) {
            for (AiProxyApiKeyDataSubscriber s : this.subscribers) {
                s.unSubscribe(data);
            }
        }
    }
}

