/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util.prometheus.parser.sample;

import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.prometheus.parser.sample.Context;
import org.apache.skywalking.oap.server.library.util.prometheus.parser.sample.State;

public class TextSample {
    private final String name;
    private final Map<String, String> labels;
    private final String value;
    private final String line;

    public static TextSample parse(String line) {
        Context ctx = new Context();
        State state = State.NAME;
        for (int c = 0; c < line.length(); ++c) {
            char charAt = line.charAt(c);
            if ((state = state.nextState(charAt, ctx)) == State.INVALID) {
                throw new IllegalStateException(String.format("At offset %d, character is %c", c, Character.valueOf(charAt)));
            }
            if (state == State.END) break;
        }
        return new TextSample(ctx.name.toString(), ctx.labels, ctx.value.toString(), line);
    }

    @Generated
    private TextSample(String name, Map<String, String> labels, String value, String line) {
        this.name = name;
        this.labels = labels;
        this.value = value;
        this.line = line;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getLine() {
        return this.line;
    }
}

