/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.consul;

import com.google.common.base.Splitter;
import com.google.common.net.HostAndPort;
import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.cache.KVCache;
import com.orbitz.consul.model.kv.Value;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.FetchingConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigTable;
import org.apache.skywalking.oap.server.configuration.consul.ConsulConfigurationCenterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulConfigurationWatcherRegister
extends FetchingConfigWatcherRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsulConfigurationWatcherRegister.class);
    private static final int DEFAULT_PORT = 8500;
    private final KeyValueClient consul;
    private final Map<String, Optional<String>> configItemKeyedByName = new ConcurrentHashMap<String, Optional<String>>();
    private final Map<String, KVCache> cachesByKey = new ConcurrentHashMap<String, KVCache>();

    public ConsulConfigurationWatcherRegister(ConsulConfigurationCenterSettings settings) {
        super(settings.getPeriod());
        List hostAndPorts = Splitter.on((String)",").splitToList((CharSequence)settings.getHostAndPorts()).parallelStream().map(hostAndPort -> HostAndPort.fromString((String)hostAndPort).withDefaultPort(8500)).collect(Collectors.toList());
        Consul.Builder builder = Consul.builder().withConnectTimeoutMillis(3000L).withReadTimeoutMillis(20000L);
        if (hostAndPorts.size() == 1) {
            builder.withHostAndPort((HostAndPort)hostAndPorts.get(0));
        } else {
            builder.withMultipleHostAndPort(hostAndPorts, 5000L);
        }
        if (StringUtils.isNotEmpty((CharSequence)settings.getAclToken())) {
            builder.withAclToken(settings.getAclToken());
        }
        this.consul = builder.build().keyValueClient();
    }

    public Optional<ConfigTable> readConfig(Set<String> keys) {
        this.removeUninterestedKeys(keys);
        this.registerKeyListeners(keys);
        ConfigTable table = new ConfigTable();
        this.configItemKeyedByName.forEach((key, value) -> {
            if (value.isPresent()) {
                table.add(new ConfigTable.ConfigItem(key, (String)value.get()));
            } else {
                table.add(new ConfigTable.ConfigItem(key, null));
            }
        });
        return Optional.of(table);
    }

    public Optional<GroupConfigTable> readGroupConfig(Set<String> keys) {
        GroupConfigTable groupConfigTable = new GroupConfigTable();
        keys.forEach(key -> {
            GroupConfigTable.GroupConfigItems groupConfigItems = new GroupConfigTable.GroupConfigItems(key);
            groupConfigTable.addGroupConfigItems(groupConfigItems);
            String groupKey = key + "/";
            List groupItemKeys = this.consul.getKeys(groupKey);
            if (groupItemKeys != null) {
                groupItemKeys.stream().filter(it -> !groupKey.equals(it)).forEach(groupItemKey -> {
                    Optional itemValue = this.consul.getValueAsString(groupItemKey);
                    String itemName = groupItemKey.substring(groupKey.length());
                    groupConfigItems.add(new ConfigTable.ConfigItem(itemName, (String)itemValue.orElse(null)));
                });
            }
        });
        return Optional.of(groupConfigTable);
    }

    private void registerKeyListeners(Set<String> keys) {
        HashSet<String> unregisterKeys = new HashSet<String>(keys);
        unregisterKeys.removeAll(this.cachesByKey.keySet());
        unregisterKeys.forEach(key -> {
            KVCache cache = KVCache.newCache((KeyValueClient)this.consul, (String)key);
            cache.addListener(newValues -> {
                Optional<Value> value = newValues.values().stream().filter(it -> key.equals(it.getKey())).findAny();
                if (value.isPresent()) {
                    this.onKeyValueChanged((String)key, value.get().getValueAsString().orElse(null));
                } else {
                    this.onKeyValueChanged((String)key, null);
                }
            });
            cache.start();
            this.cachesByKey.put((String)key, cache);
        });
    }

    private void removeUninterestedKeys(Set<String> interestedKeys) {
        HashSet<String> uninterestedKeys = new HashSet<String>(this.cachesByKey.keySet());
        uninterestedKeys.removeAll(interestedKeys);
        uninterestedKeys.forEach(k -> {
            KVCache cache = this.cachesByKey.remove(k);
            if (cache != null) {
                cache.stop();
            }
        });
    }

    private void onKeyValueChanged(String key, String value) {
        if (log.isInfoEnabled()) {
            log.info("Consul config changed: {}: {}", (Object)key, (Object)value);
        }
        this.configItemKeyedByName.put(key, Optional.ofNullable(value));
    }
}

