/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.AsyncLoader;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultAsyncLoader<T>
implements AsyncLoader<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAsyncLoader.class);
    private static final AtomicReferenceFieldUpdater<DefaultAsyncLoader, CompletableFuture> loadFutureUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultAsyncLoader.class, CompletableFuture.class, "loadingFuture");
    private final Function<@Nullable T, CompletableFuture<T>> loader;
    private final long expireAfterLoadNanos;
    @Nullable
    private final Predicate<? super T> expireIf;
    @Nullable
    private final Predicate<? super T> refreshIf;
    @Nullable
    private final @Nullable BiFunction<? super Throwable, ? super @Nullable T, ? extends @Nullable CompletableFuture<T>> exceptionHandler;
    @Nullable
    private volatile CacheEntry<T> cacheEntry;
    private volatile CompletableFuture<T> loadingFuture = UnmodifiableFuture.completedFuture(null);

    DefaultAsyncLoader(Function<@Nullable T, CompletableFuture<T>> loader, @Nullable Duration expireAfterLoad, @Nullable Predicate<? super T> expireIf, @Nullable Predicate<? super T> refreshIf, @Nullable @Nullable BiFunction<? super Throwable, ? super @Nullable T, ? extends @Nullable CompletableFuture<T>> exceptionHandler) {
        Objects.requireNonNull(loader, "loader");
        this.loader = loader;
        this.expireAfterLoadNanos = expireAfterLoad != null ? expireAfterLoad.toNanos() : 0L;
        this.expireIf = expireIf;
        this.refreshIf = refreshIf;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public CompletableFuture<T> load() {
        boolean tryLoad;
        CompletableFuture<T> loadingFuture = this.loadingFuture;
        if (!loadingFuture.isDone()) {
            return this.cacheOrFuture(this.cacheEntry, loadingFuture);
        }
        CacheEntry<T> cacheEntry = this.cacheEntry;
        boolean isValid = this.isValid(cacheEntry);
        if (isValid) {
            assert (cacheEntry != null);
            tryLoad = this.needsRefresh(cacheEntry);
        } else {
            tryLoad = true;
        }
        if (tryLoad) {
            CompletableFuture newFuture = new CompletableFuture();
            if (loadFutureUpdater.compareAndSet(this, loadingFuture, newFuture)) {
                return this.logAndLoad(cacheEntry, isValid, newFuture);
            }
            return this.cacheOrFuture(this.cacheEntry, this.loadingFuture);
        }
        return this.cacheOrFuture(cacheEntry, loadingFuture);
    }

    private void load(@Nullable T cache, CompletableFuture<T> future) {
        try {
            this.loader.apply(cache).handle((newValue, cause) -> {
                if (cause != null) {
                    logger.warn("Failed to load a new value from loader: {}. cache: {}", this.loader, cache, cause);
                    this.handleException((Throwable)cause, cache, future);
                } else {
                    logger.debug("Loaded a new value: {}", newValue);
                    this.cacheEntry = new CacheEntry<Object>(newValue);
                    future.complete(newValue);
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.warn("Unexpected exception from loader.apply()", e);
            this.handleException(e, cache, future);
        }
    }

    @Nonnull
    private CompletableFuture<T> logAndLoad(@Nullable CacheEntry<T> cacheEntry, boolean isValid, CompletableFuture<T> newFuture) {
        Object cache;
        assert (!isValid || cacheEntry != null);
        Object object = cache = cacheEntry != null ? ((CacheEntry)cacheEntry).value : null;
        if (isValid) {
            logger.debug("Pre-fetching a new value. cache: {}, loader: {}", cache, (Object)this.loader);
        } else {
            logger.debug("Loading a new value. cache: {}, loader: {}", cache, (Object)this.loader);
        }
        this.load(cache, newFuture);
        if (isValid) {
            return UnmodifiableFuture.completedFuture(cache);
        }
        return newFuture;
    }

    private CompletableFuture<T> cacheOrFuture(@Nullable CacheEntry<T> cacheEntry, CompletableFuture<T> future) {
        if (this.isValid(cacheEntry)) {
            assert (cacheEntry != null);
            return UnmodifiableFuture.completedFuture(((CacheEntry)cacheEntry).value);
        }
        return future;
    }

    private boolean needsRefresh(CacheEntry<T> cacheEntry) {
        boolean refresh = false;
        Object cache = ((CacheEntry)cacheEntry).value;
        try {
            refresh = this.refreshIf != null && this.refreshIf.test(cache);
        }
        catch (Exception e) {
            logger.warn("Unexpected exception from refreshIf.test()", e);
        }
        return refresh;
    }

    private void handleException(Throwable cause, @Nullable T cache, CompletableFuture<T> future) {
        if (this.exceptionHandler == null) {
            future.completeExceptionally(cause);
            return;
        }
        try {
            CompletableFuture<T> fallback = this.exceptionHandler.apply((Throwable)((Throwable)cause), (Throwable)cache);
            if (fallback == null) {
                future.completeExceptionally(cause);
                return;
            }
            fallback.handle((newValue, cause0) -> {
                if (cause0 != null) {
                    logger.warn("Failed to load a new value from exceptionHandler: {}. cache: {}", this.exceptionHandler, cache, cause0);
                    future.completeExceptionally((Throwable)cause0);
                } else {
                    this.cacheEntry = new CacheEntry<Object>(newValue);
                    future.complete(newValue);
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.warn("Unexpected exception from exceptionHandler.apply()", e);
            future.completeExceptionally(cause);
        }
    }

    private boolean isValid(@Nullable CacheEntry<T> cacheEntry) {
        long elapsed;
        if (cacheEntry == null) {
            return false;
        }
        if (this.expireAfterLoadNanos > 0L && (elapsed = System.nanoTime() - ((CacheEntry)cacheEntry).cachedAtNanos) >= this.expireAfterLoadNanos) {
            if (logger.isDebugEnabled()) {
                logger.debug("The cached value expired after {} ms. cache: {}", (Object)TimeUnit.NANOSECONDS.toMillis(this.expireAfterLoadNanos), ((CacheEntry)cacheEntry).value);
            }
            return false;
        }
        try {
            if (this.expireIf != null && this.expireIf.test(((CacheEntry)cacheEntry).value)) {
                logger.debug("The cached value expired due to 'expireIf' condition. cache: {}", ((CacheEntry)cacheEntry).value);
                return false;
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected exception from expireIf.test()", e);
        }
        return true;
    }

    private static final class CacheEntry<T> {
        @Nullable
        private final T value;
        private final long cachedAtNanos = System.nanoTime();

        CacheEntry(@Nullable T value) {
            this.value = value;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("value", this.value).add("cachedAtNanos", this.cachedAtNanos).toString();
        }
    }
}

