/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.qtesla;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Set;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PrivateKey;

public class BCqTESLAPrivateKey
implements PrivateKey {
    private transient QTESLAPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCqTESLAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.keyParams = (QTESLAPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public final String getAlgorithm() {
        return QTESLASecurityCategory.getName(this.keyParams.getSecurityCategory());
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCqTESLAPrivateKey) {
            BCqTESLAPrivateKey bCqTESLAPrivateKey = (BCqTESLAPrivateKey)object;
            return this.keyParams.getSecurityCategory() == bCqTESLAPrivateKey.keyParams.getSecurityCategory() && Arrays.areEqual(this.keyParams.getSecret(), bCqTESLAPrivateKey.keyParams.getSecret());
        }
        return false;
    }

    public int hashCode() {
        return this.keyParams.getSecurityCategory() + 37 * Arrays.hashCode(this.keyParams.getSecret());
    }
}

