/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.server.ServerPortMetric;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConnectionLimitingHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionLimitingHandler.class);
    private final Set<Channel> childChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Channel> unmodifiableChildChannels = Collections.unmodifiableSet(this.childChannels);
    private final int maxNumConnections;
    private final AtomicInteger activeConnections = new AtomicInteger();
    private final AtomicBoolean loggingScheduled = new AtomicBoolean();
    private final LongAdder numDroppedConnections = new LongAdder();

    ConnectionLimitingHandler(int maxNumConnections) {
        this.maxNumConnections = ConnectionLimitingHandler.validateMaxNumConnections(maxNumConnections);
    }

    int maxNumConnections() {
        return this.maxNumConnections;
    }

    int numConnections() {
        return this.activeConnections.get();
    }

    Set<Channel> children() {
        return this.unmodifiableChildChannels;
    }

    static int validateMaxNumConnections(int maxNumConnections) {
        if (maxNumConnections <= 0) {
            throw new IllegalArgumentException("maxNumConnections: " + maxNumConnections + " (expected: > 0)");
        }
        return maxNumConnections;
    }

    ChannelHandler newChildHandler(ServerPortMetric serverPortMetric) {
        return new ConnectionLimitingChildHandler(serverPortMetric);
    }

    @ChannelHandler.Sharable
    private class ConnectionLimitingChildHandler
    extends ChannelInboundHandlerAdapter {
        private final ServerPortMetric serverPortMetric;

        ConnectionLimitingChildHandler(ServerPortMetric serverPortMetric) {
            this.serverPortMetric = serverPortMetric;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel child = (Channel)msg;
            int conn = ConnectionLimitingHandler.this.activeConnections.incrementAndGet();
            if (conn > 0 && conn <= ConnectionLimitingHandler.this.maxNumConnections) {
                this.serverPortMetric.increaseActiveConnections();
                ConnectionLimitingHandler.this.childChannels.add(child);
                child.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                    ConnectionLimitingHandler.this.childChannels.remove(child);
                    ConnectionLimitingHandler.this.activeConnections.decrementAndGet();
                    this.serverPortMetric.decreaseActiveConnections();
                }));
                super.channelRead(ctx, msg);
            } else {
                ConnectionLimitingHandler.this.activeConnections.decrementAndGet();
                child.config().setOption(ChannelOption.SO_LINGER, 0);
                child.unsafe().closeForcibly();
                ConnectionLimitingHandler.this.numDroppedConnections.increment();
                if (ConnectionLimitingHandler.this.loggingScheduled.compareAndSet(false, true)) {
                    ctx.executor().schedule(this::writeNumDroppedConnectionsLog, 1L, TimeUnit.SECONDS);
                }
            }
        }

        private void writeNumDroppedConnectionsLog() {
            ConnectionLimitingHandler.this.loggingScheduled.set(false);
            long dropped = ConnectionLimitingHandler.this.numDroppedConnections.sumThenReset();
            if (dropped > 0L) {
                logger.warn("Dropped {} connection(s) to limit the number of open connections to {}", (Object)dropped, (Object)ConnectionLimitingHandler.this.maxNumConnections);
            }
        }
    }
}

