/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.source.K8SMetrics;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;

@ScopeDeclaration(id=76, name="K8SEndpoint", catalog="ENDPOINT")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class K8SEndpoint
extends K8SMetrics.ProtocolMetrics {
    private volatile String entityId;
    @ScopeDefaultColumn.DefinedByField(columnName="service_id")
    @ScopeDefaultColumn.BanyanDB(groupByCondInTopN=true)
    private String serviceId;
    @ScopeDefaultColumn.DefinedByField(columnName="service_name", requireDynamicActive=true)
    private String serviceName;
    private Layer layer;
    @ScopeDefaultColumn.DefinedByField(columnName="name", requireDynamicActive=true)
    private String endpointName;
    private long duration;

    @Override
    public int scope() {
        return 76;
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public void prepare() {
        this.serviceId = IDManager.ServiceID.buildId(this.serviceName, this.layer.isNormal());
        this.entityId = IDManager.EndpointID.buildId(this.serviceId, this.endpointName);
    }

    @Generated
    public K8SEndpoint() {
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public Layer getLayer() {
        return this.layer;
    }

    @Generated
    public String getEndpointName() {
        return this.endpointName;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Generated
    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof K8SEndpoint)) {
            return false;
        }
        K8SEndpoint other = (K8SEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        if (this$layer == null ? other$layer != null : !((Object)((Object)this$layer)).equals((Object)other$layer)) {
            return false;
        }
        String this$endpointName = this.getEndpointName();
        String other$endpointName = other.getEndpointName();
        return !(this$endpointName == null ? other$endpointName != null : !this$endpointName.equals(other$endpointName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof K8SEndpoint;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 43 : ((Object)((Object)$layer)).hashCode());
        String $endpointName = this.getEndpointName();
        result = result * 59 + ($endpointName == null ? 43 : $endpointName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "K8SEndpoint(entityId=" + this.getEntityId() + ", serviceId=" + this.getServiceId() + ", serviceName=" + this.getServiceName() + ", layer=" + this.getLayer() + ", endpointName=" + this.getEndpointName() + ", duration=" + this.getDuration() + ")";
    }
}

