/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.zipkin;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="zipkin_service_relation_traffic", scopeId=53, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=false)
@BanyanDB.IndexMode
public class ZipkinServiceRelationTraffic
extends Metrics {
    public static final String INDEX_NAME = "zipkin_service_relation_traffic";
    public static final String SERVICE_NAME = "service_name";
    public static final String REMOTE_SERVICE_NAME = "remote_service_name";
    @Column(name="service_name")
    @BanyanDB.SeriesID(index=0)
    private String serviceName;
    @Column(name="remote_service_name")
    @BanyanDB.SeriesID(index=1)
    private String remoteServiceName;

    @Override
    protected StorageID id0() {
        return new StorageID().append(SERVICE_NAME, this.serviceName).append(REMOTE_SERVICE_NAME, this.remoteServiceName);
    }

    @Override
    public boolean combine(Metrics metrics) {
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setServiceName(remoteData.getDataStrings(0));
        this.setRemoteServiceName(remoteData.getDataStrings(1));
        this.setTimeBucket(remoteData.getDataLongs(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataStrings(this.getServiceName());
        remoteBuilder.addDataStrings(this.getRemoteServiceName());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        return remoteBuilder;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZipkinServiceRelationTraffic)) {
            return false;
        }
        ZipkinServiceRelationTraffic other = (ZipkinServiceRelationTraffic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$remoteServiceName = this.getRemoteServiceName();
        String other$remoteServiceName = other.getRemoteServiceName();
        return !(this$remoteServiceName == null ? other$remoteServiceName != null : !this$remoteServiceName.equals(other$remoteServiceName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZipkinServiceRelationTraffic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $remoteServiceName = this.getRemoteServiceName();
        result = result * 59 + ($remoteServiceName == null ? 43 : $remoteServiceName.hashCode());
        return result;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setRemoteServiceName(String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
    }

    @Generated
    public String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public static class Builder
    implements StorageBuilder<ZipkinServiceRelationTraffic> {
        @Override
        public ZipkinServiceRelationTraffic storage2Entity(Convert2Entity converter) {
            ZipkinServiceRelationTraffic metrics = new ZipkinServiceRelationTraffic();
            metrics.setServiceName((String)converter.get(ZipkinServiceRelationTraffic.SERVICE_NAME));
            metrics.setRemoteServiceName((String)converter.get(ZipkinServiceRelationTraffic.REMOTE_SERVICE_NAME));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return metrics;
        }

        @Override
        public void entity2Storage(ZipkinServiceRelationTraffic storageData, Convert2Storage converter) {
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(ZipkinServiceRelationTraffic.SERVICE_NAME, storageData.getServiceName());
            converter.accept(ZipkinServiceRelationTraffic.REMOTE_SERVICE_NAME, storageData.getRemoteServiceName());
        }
    }
}

