/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.mx;

import Wasm.Common.FlatNode;
import Wasm.Common.KeyVal;
import com.google.common.base.Strings;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.FieldsHelper;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMetaInfoAdapter
extends ServiceMetaInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceMetaInfoAdapter.class);

    public ServiceMetaInfoAdapter(ByteString bv) throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap(BytesValue.parseFrom((ByteString)bv).getValue().toByteArray());
        FlatNode flatNode = FlatNode.getRootAsFlatNode((ByteBuffer)buffer);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < flatNode.labelsLength(); ++i) {
                KeyVal kv = flatNode.labels(i);
                if (!Objects.nonNull(kv)) continue;
                log.debug("wasm label: {} : {}", (Object)kv.key(), (Object)kv.value());
            }
        }
        Struct metadata = Objects.requireNonNull(ServiceMetaInfoAdapter.extractStructFromNodeFlatBuffer(flatNode));
        if (log.isDebugEnabled()) {
            log.debug("Node metadata: {}", (Object)metadata);
        }
        FieldsHelper.forClass(this.getClass().getSuperclass()).inflate(metadata, (Object)this);
        this.appendTags(metadata);
    }

    public ServiceMetaInfoAdapter(Any any) throws Exception {
        this(any.getValue());
    }

    public static Struct extractStructFromNodeFlatBuffer(FlatNode node) {
        Struct.Builder builder = Struct.newBuilder();
        builder.putFields("NAME", Value.newBuilder().setStringValue(Strings.nullToEmpty((String)node.name())).build());
        builder.putFields("NAMESPACE", Value.newBuilder().setStringValue(Strings.nullToEmpty((String)node.namespace())).build());
        builder.putFields("CLUSTER_ID", Value.newBuilder().setStringValue(Strings.nullToEmpty((String)node.clusterId())).build());
        Struct.Builder labels = Struct.newBuilder();
        for (int i = 0; i < node.labelsLength(); ++i) {
            KeyVal label = node.labels(i);
            labels.putFields(Strings.nullToEmpty((String)label.key()), Value.newBuilder().setStringValue(Strings.nullToEmpty((String)label.value())).build());
        }
        builder.putFields("LABELS", Value.newBuilder().setStructValue(labels).build());
        return builder.build();
    }

    public ServiceMetaInfoAdapter(Struct metadata) {
        FieldsHelper.forClass(this.getClass().getSuperclass()).inflate(Objects.requireNonNull(metadata), (Object)this);
        this.appendTags(Objects.requireNonNull(metadata));
        if (log.isDebugEnabled()) {
            log.info("Metadata is converted to: {}", (Object)this);
        }
    }

    private void appendTags(Struct metadata) {
        TreeMap fieldsMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        fieldsMap.putAll(metadata.getFieldsMap());
        if (log.isDebugEnabled()) {
            log.debug("Metadata field map: {}", fieldsMap);
        }
        ArrayList<ServiceMetaInfo.KeyValue> tags = new ArrayList<ServiceMetaInfo.KeyValue>();
        if (fieldsMap.containsKey("NAME")) {
            tags.add(new ServiceMetaInfo.KeyValue("pod", ((Value)fieldsMap.get("NAME")).getStringValue()));
        }
        if (fieldsMap.containsKey("NAMESPACE")) {
            tags.add(new ServiceMetaInfo.KeyValue("namespace", ((Value)fieldsMap.get("NAMESPACE")).getStringValue()));
        }
        if (log.isDebugEnabled()) {
            log.debug("Converted tags: {}", tags);
        }
        if (!tags.isEmpty()) {
            this.setTags(tags);
        }
    }

    @Generated
    public ServiceMetaInfoAdapter() {
    }
}

