/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import io.grpc.Channel;
import java.util.List;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.database.v1.GroupRegistryServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.grpc.MetadataClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.ResourceExist;

public class GroupMetadataRegistry
extends MetadataClient<GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub, BanyandbCommon.Group> {
    public GroupMetadataRegistry(Channel channel) {
        super(GroupRegistryServiceGrpc.newBlockingStub(channel));
    }

    @Override
    public long create(BanyandbCommon.Group payload) throws BanyanDBException {
        this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).create(BanyandbDatabase.GroupRegistryServiceCreateRequest.newBuilder().setGroup(payload).build()));
        return 0L;
    }

    @Override
    public void update(BanyandbCommon.Group payload) throws BanyanDBException {
        this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).update(BanyandbDatabase.GroupRegistryServiceUpdateRequest.newBuilder().setGroup(payload).build()));
    }

    @Override
    public boolean delete(String group, String name) throws BanyanDBException {
        BanyandbDatabase.GroupRegistryServiceDeleteResponse resp = this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).delete(BanyandbDatabase.GroupRegistryServiceDeleteRequest.newBuilder().setGroup(name).build()));
        return resp != null && resp.getDeleted();
    }

    @Override
    public BanyandbCommon.Group get(String group, String name) throws BanyanDBException {
        BanyandbDatabase.GroupRegistryServiceGetResponse resp = this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).get(BanyandbDatabase.GroupRegistryServiceGetRequest.newBuilder().setGroup(name).build()));
        return resp.getGroup();
    }

    @Override
    public ResourceExist exist(String group, String name) throws BanyanDBException {
        BanyandbDatabase.GroupRegistryServiceExistResponse resp = this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).exist(BanyandbDatabase.GroupRegistryServiceExistRequest.newBuilder().setGroup(name).build()));
        return ResourceExist.create(resp.getHasGroup(), resp.getHasGroup());
    }

    @Override
    public List<BanyandbCommon.Group> list(String group) throws BanyanDBException {
        BanyandbDatabase.GroupRegistryServiceListResponse resp = this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).list(BanyandbDatabase.GroupRegistryServiceListRequest.newBuilder().build()));
        return resp.getGroupList();
    }
}

