/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.Endpoint;
import org.apache.skywalking.oap.server.core.source.RequestType;

class EndpointSourceBuilder {
    protected final NamingControl namingControl;
    protected long timeBucket;
    protected String destServiceName;
    protected Layer destLayer;
    protected String destServiceInstanceName;
    protected String destEndpointName;
    protected int latency;
    protected boolean status;
    protected int httpResponseStatusCode;
    protected String rpcStatusCode;
    protected RequestType type;
    protected DetectPoint detectPoint;
    protected final List<String> tags = new ArrayList<String>();
    protected final Map<String, String> originalTags = new HashMap<String, String>();

    void prepare() {
        this.destServiceName = this.namingControl.formatServiceName(this.destServiceName);
        this.destServiceInstanceName = this.namingControl.formatInstanceName(this.destServiceInstanceName);
        this.destEndpointName = this.namingControl.formatEndpointName(this.destServiceName, this.destEndpointName);
    }

    Endpoint toEndpoint() {
        Endpoint endpoint = new Endpoint();
        endpoint.setName(this.destEndpointName);
        endpoint.setServiceName(this.destServiceName);
        endpoint.setServiceLayer(this.destLayer);
        endpoint.setServiceInstanceName(this.destServiceInstanceName);
        endpoint.setLatency(this.latency);
        endpoint.setStatus(this.status);
        endpoint.setHttpResponseStatusCode(this.httpResponseStatusCode);
        endpoint.setRpcStatusCode(this.rpcStatusCode);
        endpoint.setType(this.type);
        endpoint.setTags(this.tags);
        endpoint.setOriginalTags(this.originalTags);
        endpoint.setTimeBucket(this.timeBucket);
        return endpoint;
    }

    void setTag(KeyStringValuePair tag) {
        this.tags.add(tag.getKey().trim() + ":" + tag.getValue().trim());
        this.originalTags.put(tag.getKey(), tag.getValue());
    }

    @Generated
    public EndpointSourceBuilder(NamingControl namingControl) {
        this.namingControl = namingControl;
    }

    @Generated
    public long getTimeBucket() {
        return this.timeBucket;
    }

    @Generated
    public void setTimeBucket(long timeBucket) {
        this.timeBucket = timeBucket;
    }

    @Generated
    public String getDestServiceName() {
        return this.destServiceName;
    }

    @Generated
    public void setDestServiceName(String destServiceName) {
        this.destServiceName = destServiceName;
    }

    @Generated
    public Layer getDestLayer() {
        return this.destLayer;
    }

    @Generated
    public void setDestLayer(Layer destLayer) {
        this.destLayer = destLayer;
    }

    @Generated
    public String getDestServiceInstanceName() {
        return this.destServiceInstanceName;
    }

    @Generated
    public void setDestServiceInstanceName(String destServiceInstanceName) {
        this.destServiceInstanceName = destServiceInstanceName;
    }

    @Generated
    public String getDestEndpointName() {
        return this.destEndpointName;
    }

    @Generated
    public void setDestEndpointName(String destEndpointName) {
        this.destEndpointName = destEndpointName;
    }

    @Generated
    public int getLatency() {
        return this.latency;
    }

    @Generated
    public void setLatency(int latency) {
        this.latency = latency;
    }

    @Generated
    public boolean isStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(boolean status) {
        this.status = status;
    }

    @Generated
    public int getHttpResponseStatusCode() {
        return this.httpResponseStatusCode;
    }

    @Generated
    public void setHttpResponseStatusCode(int httpResponseStatusCode) {
        this.httpResponseStatusCode = httpResponseStatusCode;
    }

    @Generated
    public String getRpcStatusCode() {
        return this.rpcStatusCode;
    }

    @Generated
    public void setRpcStatusCode(String rpcStatusCode) {
        this.rpcStatusCode = rpcStatusCode;
    }

    @Generated
    public RequestType getType() {
        return this.type;
    }

    @Generated
    public void setType(RequestType type) {
        this.type = type;
    }

    @Generated
    public DetectPoint getDetectPoint() {
        return this.detectPoint;
    }

    @Generated
    public void setDetectPoint(DetectPoint detectPoint) {
        this.detectPoint = detectPoint;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public Map<String, String> getOriginalTags() {
        return this.originalTags;
    }
}

