/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.cilium.nodes;

import io.cilium.api.observer.ObserverGrpc;
import io.vavr.Tuple2;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.apache.skywalking.oap.server.fetcher.cilium.nodes.ClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiliumNode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CiliumNode.class);
    private final String address;
    private final ClientBuilder clientBuilder;
    private volatile ObserverGrpc.ObserverBlockingStub observerStub;
    private volatile boolean closed;
    private final CopyOnWriteArrayList<Closeable> closeables = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObserverGrpc.ObserverBlockingStub getObserverStub() {
        if (this.closed) {
            return null;
        }
        if (Objects.nonNull(this.observerStub)) {
            return this.observerStub;
        }
        CiliumNode ciliumNode = this;
        synchronized (ciliumNode) {
            if (Objects.isNull(this.observerStub)) {
                Tuple2<String, Integer> addressTuple = this.parseAddress();
                this.observerStub = this.clientBuilder.buildClient((String)addressTuple._1, (Integer)addressTuple._2, ObserverGrpc.ObserverBlockingStub.class);
            }
        }
        return this.observerStub;
    }

    public void addingCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    public void close() {
        this.closed = true;
        this.closeables.forEach(c -> {
            try {
                c.close();
            }
            catch (Exception e) {
                log.warn("Failed to close the cilium node", (Throwable)e);
            }
        });
    }

    private Tuple2<String, Integer> parseAddress() {
        String[] parts = this.address.split(":");
        if (parts.length != 2) {
            return new Tuple2((Object)this.address, (Object)4244);
        }
        return new Tuple2((Object)parts[0], (Object)Integer.parseInt(parts[1]));
    }

    @Generated
    public CiliumNode(String address, ClientBuilder clientBuilder) {
        this.address = address;
        this.clientBuilder = clientBuilder;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public ClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    @Generated
    public boolean isClosed() {
        return this.closed;
    }

    @Generated
    public CopyOnWriteArrayList<Closeable> getCloseables() {
        return this.closeables;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CiliumNode)) {
            return false;
        }
        CiliumNode other = (CiliumNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CiliumNode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CiliumNode(address=" + this.getAddress() + ")";
    }
}

