/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.apache.skywalking.oap.server.library.util.YamlConfigLoaderUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class BanyanDBConfigLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBConfigLoader.class);
    private final ModuleProvider moduleProvider;
    private final BanyanDBStorageConfig config;
    private final Yaml yaml;

    public BanyanDBConfigLoader(ModuleProvider moduleProvider) {
        this.moduleProvider = moduleProvider;
        this.config = new BanyanDBStorageConfig();
        this.yaml = new Yaml();
    }

    public BanyanDBStorageConfig loadConfig() throws ModuleStartException {
        this.loadBaseConfig();
        this.loadTopNConfig();
        return this.config;
    }

    private void loadBaseConfig() throws ModuleStartException {
        Reader applicationReader;
        try {
            applicationReader = ResourceUtils.read((String)"bydb.yml");
        }
        catch (FileNotFoundException e) {
            throw new ModuleStartException("Cannot find the BanyanDB configuration file [bydb.yml].", (Throwable)e);
        }
        Map configMap = (Map)this.yaml.loadAs(applicationReader, Map.class);
        if (configMap == null) {
            return;
        }
        HashMap configProperties = new HashMap();
        configMap.forEach((part, c) -> {
            if (c != null) {
                Properties properties = this.parseConfig((Map<String, ?>)c);
                configProperties.put(part, properties);
            }
        });
        try {
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getGlobal(), (Properties)((Properties)configProperties.get("global")), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            Properties groups = (Properties)configProperties.get("groups");
            Properties recordsNormal = (Properties)groups.get(BanyanDB.StreamGroup.RECORDS.getName());
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getRecordsNormal(), (Properties)recordsNormal, (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            this.copyStages(recordsNormal, this.config.getRecordsNormal());
            Properties log = (Properties)groups.get(BanyanDB.StreamGroup.RECORDS_LOG.getName());
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getRecordsLog(), (Properties)log, (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            this.copyStages(log, this.config.getRecordsLog());
            Properties segment = (Properties)groups.get(BanyanDB.TraceGroup.TRACE.getName());
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getTrace(), (Properties)segment, (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            this.copyStages(segment, this.config.getTrace());
            Properties zipkinSpan = (Properties)groups.get(BanyanDB.TraceGroup.ZIPKIN_TRACE.getName());
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getZipkinTrace(), (Properties)zipkinSpan, (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            this.copyStages(zipkinSpan, this.config.getZipkinTrace());
            Properties browserErrorLog = (Properties)groups.get(BanyanDB.StreamGroup.RECORDS_BROWSER_ERROR_LOG.getName());
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getRecordsBrowserErrorLog(), (Properties)browserErrorLog, (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            this.copyStages(browserErrorLog, this.config.getRecordsBrowserErrorLog());
            Properties metricsMin = (Properties)groups.get(BanyanDB.MeasureGroup.METRICS_MINUTE.getName());
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getMetricsMin(), (Properties)metricsMin, (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            this.copyStages(metricsMin, this.config.getMetricsMin());
            Properties metricsHour = (Properties)groups.get(BanyanDB.MeasureGroup.METRICS_HOUR.getName());
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getMetricsHour(), (Properties)metricsHour, (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            this.copyStages(metricsHour, this.config.getMetricsHour());
            Properties metricsDay = (Properties)groups.get(BanyanDB.MeasureGroup.METRICS_DAY.getName());
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getMetricsDay(), (Properties)metricsDay, (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            this.copyStages(metricsDay, this.config.getMetricsDay());
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getMetadata(), (Properties)((Properties)groups.get(BanyanDB.MeasureGroup.METADATA.getName())), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            YamlConfigLoaderUtils.copyProperties((Object)this.config.getProperty(), (Properties)((Properties)groups.get(BanyanDB.PropertyGroup.PROPERTY.getName())), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
        }
        catch (IllegalAccessException e) {
            throw new ModuleStartException("Failed to load BanyanDB configuration.", (Throwable)e);
        }
    }

    private Properties parseConfig(Map<String, ?> config) {
        Properties properties = new Properties();
        for (Map.Entry<String, ?> entry : config.entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            if (propertyValue instanceof Map) {
                Properties subProperties = this.parseConfig((Map)propertyValue);
                properties.put(propertyName, subProperties);
                continue;
            }
            properties.put(propertyName, propertyValue);
            YamlConfigLoaderUtils.replacePropertyAndLog((String)propertyName, propertyValue, (Properties)properties, (Object)this.moduleProvider.name(), (Yaml)this.yaml);
        }
        return properties;
    }

    private void copyStages(Properties group, BanyanDBStorageConfig.GroupResource groupResource) throws IllegalAccessException {
        if (groupResource.isEnableWarmStage()) {
            BanyanDBStorageConfig.Stage warm = new BanyanDBStorageConfig.Stage();
            warm.setName(BanyanDBStorageConfig.StageName.warm);
            YamlConfigLoaderUtils.copyProperties((Object)warm, (Properties)((Properties)group.get(BanyanDBStorageConfig.StageName.warm.name())), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            groupResource.getAdditionalLifecycleStages().add(warm);
            groupResource.getDefaultQueryStages().add(BanyanDBStorageConfig.StageName.warm.name());
        }
        if (groupResource.isEnableColdStage()) {
            BanyanDBStorageConfig.Stage cold = new BanyanDBStorageConfig.Stage();
            cold.setName(BanyanDBStorageConfig.StageName.cold);
            cold.setClose(true);
            YamlConfigLoaderUtils.copyProperties((Object)cold, (Properties)((Properties)group.get(BanyanDBStorageConfig.StageName.cold.name())), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            groupResource.getAdditionalLifecycleStages().add(cold);
        }
    }

    private void loadTopNConfig() throws ModuleStartException {
        Reader applicationReader;
        try {
            applicationReader = ResourceUtils.read((String)"bydb-topn.yml");
        }
        catch (FileNotFoundException e) {
            throw new ModuleStartException("Cannot find the BanyanDB topN configuration file [bydb-topn.yml].", (Throwable)e);
        }
        Map configMap = (Map)new Yaml().loadAs(applicationReader, Map.class);
        if (configMap == null) {
            return;
        }
        List topNConfig = (List)configMap.get("TopN-Rules");
        if (topNConfig == null) {
            return;
        }
        for (Map rule : topNConfig) {
            Map map;
            Object excludes;
            Object sort;
            Object lruSizeHourDay;
            Object lruSizeMinute;
            Object countersNumber;
            BanyanDBStorageConfig.TopN topN = new BanyanDBStorageConfig.TopN();
            Object name = rule.get("name");
            if (name == null) {
                throw new ModuleStartException("TopN rule name is missing in file [bydb-topn.yml].");
            }
            Object metricName = rule.get("metricName");
            if (metricName == null) {
                throw new ModuleStartException("TopN rule metricName is missing in file [bydb-topn.yml].");
            }
            topN.setName(name.toString());
            Object groupByTagNames = rule.get("groupByTagNames");
            if (groupByTagNames != null) {
                topN.setGroupByTagNames((List)groupByTagNames);
            }
            if ((countersNumber = rule.get("countersNumber")) != null) {
                topN.setLruSizeMinute((Integer)countersNumber);
            }
            if ((lruSizeMinute = rule.get("lruSizeMinute")) != null) {
                topN.setLruSizeMinute((Integer)lruSizeMinute);
            }
            if ((lruSizeHourDay = rule.get("lruSizeHourDay")) != null) {
                topN.setLruSizeMinute((Integer)lruSizeHourDay);
            }
            if ((sort = rule.get("sort")) != null) {
                topN.setSort(BanyanDBStorageConfig.TopN.Sort.valueOf(sort.toString()));
            }
            if ((excludes = rule.get("excludes")) != null) {
                for (Map tag : (List)excludes) {
                    String tagName = (String)tag.get("tag");
                    String tagValue = (String)tag.get("value");
                    if (tagName == null || tagValue == null) {
                        throw new ModuleStartException("TopN rule name: " + String.valueOf(name) + ", [tag] or [value] is missing in [excludes] item in file [bydb-topn.yml].");
                    }
                    topN.getExcludes().add(new KeyValue((String)tag.get("tag"), (String)tag.get("value")));
                }
            }
            if ((map = this.config.getTopNConfigs().computeIfAbsent(metricName.toString(), k -> new HashMap())).put(name.toString(), topN) == null) continue;
            throw new ModuleStartException("Duplicate TopN rule name: " + String.valueOf(name) + " in file [bydb-topn.yml].");
        }
    }
}

