/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.trace;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanType;
import org.apache.skywalking.banyandb.trace.v1.BanyandbTrace;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.TraceQuery;
import org.apache.skywalking.banyandb.v1.client.TraceQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TraceQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.query.type.trace.v2.RetrievedTimeRange;
import org.apache.skywalking.oap.server.core.query.type.trace.v2.TracesQueryResult;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryV2DAO;
import org.apache.skywalking.oap.server.core.storage.query.proto.Source;
import org.apache.skywalking.oap.server.core.storage.query.proto.SpanWrapper;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBTraceQueryDAO
extends AbstractBanyanDBDAO
implements ITraceQueryV2DAO {
    private final int segmentQueryMaxSize;
    private final ModuleManager moduleManager;
    private NamingControl namingControl;

    public BanyanDBTraceQueryDAO(BanyanDBStorageClient client, int segmentQueryMaxSize, ModuleManager moduleManager) {
        super(client);
        this.segmentQueryMaxSize = segmentQueryMaxSize;
        this.moduleManager = moduleManager;
    }

    public TraceBrief queryBasicTraces(Duration duration, long minDuration, long maxDuration, String serviceId, String serviceInstanceId, String endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder, List<Tag> tags) throws IOException {
        throw new UnsupportedOperationException("BanyanDB Trace Model changed, please use queryTraces");
    }

    public List<SegmentRecord> queryByTraceId(String traceId, @Nullable Duration duration) throws IOException {
        throw new UnsupportedOperationException("BanyanDB Trace Model changed, please use queryByTraceIdV2");
    }

    public List<SegmentRecord> queryBySegmentIdList(final List<String> segmentIdList, @Nullable Duration duration) throws IOException {
        if (CollectionUtils.isEmpty(segmentIdList)) {
            return Collections.emptyList();
        }
        boolean isColdStage = duration != null && duration.isColdStage();
        TraceQueryResponse resp = this.queryTraceDebuggable(isColdStage, "segment", this.getTimestampRange(duration), new AbstractBanyanDBDAO.QueryBuilder<TraceQuery>(){

            @Override
            public void apply(TraceQuery query) {
                query.and(this.in("segment_id", segmentIdList));
                query.setLimit(BanyanDBTraceQueryDAO.this.segmentQueryMaxSize);
                query.setOrderBy(new AbstractQuery.OrderBy("start_time", AbstractQuery.Sort.DESC));
            }
        });
        return this.buildRecords(resp, segmentIdList, null, true);
    }

    public List<SegmentRecord> queryByTraceIdWithInstanceId(final List<String> traceIdList, final List<String> instanceIdList, @Nullable Duration duration) throws IOException {
        if (CollectionUtils.isEmpty(traceIdList) || CollectionUtils.isEmpty(instanceIdList)) {
            return Collections.emptyList();
        }
        boolean isColdStage = duration != null && duration.isColdStage();
        TraceQueryResponse resp = this.queryTraceDebuggable(isColdStage, "segment", this.getTimestampRange(duration), new AbstractBanyanDBDAO.QueryBuilder<TraceQuery>(){

            @Override
            public void apply(TraceQuery query) {
                query.and(this.in("trace_id", traceIdList));
                query.and(this.in("service_instance_id", instanceIdList));
                query.setLimit(BanyanDBTraceQueryDAO.this.segmentQueryMaxSize);
            }
        });
        return this.buildRecords(resp, null, instanceIdList, false);
    }

    public List<Span> doFlexibleTraceQuery(String traceId) throws IOException {
        return Collections.emptyList();
    }

    public List<SpanWrapper> queryByTraceIdV2(final String traceId, @Nullable Duration duration) throws IOException {
        boolean isColdStage = duration != null && duration.isColdStage();
        AbstractBanyanDBDAO.QueryBuilder<TraceQuery> query = new AbstractBanyanDBDAO.QueryBuilder<TraceQuery>(){

            @Override
            public void apply(TraceQuery query) {
                query.and(this.eq("trace_id", traceId));
                query.setLimit(BanyanDBTraceQueryDAO.this.segmentQueryMaxSize);
            }
        };
        TraceQueryResponse resp = this.queryTraceDebuggable(isColdStage, "segment", this.getTimestampRange(duration), query);
        if (resp.getTraces().isEmpty()) {
            return new ArrayList<SpanWrapper>();
        }
        if (resp.getTraces().size() > 1) {
            throw new IOException("More than one trace returned for traceId: " + traceId);
        }
        ArrayList<SpanWrapper> trace = new ArrayList<SpanWrapper>();
        for (BanyandbTrace.Span span : ((BanyandbTrace.Trace)resp.getTraces().get(0)).getSpansList()) {
            trace.add(SpanWrapper.parseFrom((ByteString)span.getSpan()));
        }
        return trace;
    }

    public TracesQueryResult queryTraces(final TraceQueryCondition condition) throws IOException {
        Duration duration = condition.getQueryDuration();
        boolean isColdStage = duration != null && duration.isColdStage();
        AbstractBanyanDBDAO.QueryBuilder<TraceQuery> query = new AbstractBanyanDBDAO.QueryBuilder<TraceQuery>(){

            @Override
            public void apply(TraceQuery query) {
                if (StringUtil.isNotBlank((String)condition.getTraceId())) {
                    query.and(this.eq("trace_id", condition.getTraceId()));
                }
                if (condition.getMinTraceDuration() != 0) {
                    query.and(this.gte("latency", condition.getMinTraceDuration()));
                }
                if (condition.getMaxTraceDuration() != 0) {
                    query.and(this.lte("latency", condition.getMaxTraceDuration()));
                }
                if (StringUtil.isNotEmpty((String)condition.getServiceId())) {
                    query.and(this.eq("service_id", condition.getServiceId()));
                }
                if (StringUtil.isNotEmpty((String)condition.getServiceInstanceId())) {
                    if (StringUtil.isEmpty((String)condition.getServiceId())) {
                        IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId((String)condition.getServiceInstanceId());
                        query.and(this.eq("service_id", instanceIDDefinition.getServiceId()));
                    }
                    query.and(this.eq("service_instance_id", condition.getServiceInstanceId()));
                }
                if (StringUtil.isNotEmpty((String)condition.getEndpointId())) {
                    if (StringUtil.isEmpty((String)condition.getServiceId())) {
                        IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId((String)condition.getEndpointId());
                        query.and(this.eq("service_id", endpointIDDefinition.getServiceId()));
                    }
                    query.and(this.eq("endpoint_id", condition.getEndpointId()));
                }
                switch (condition.getTraceState()) {
                    case ERROR: {
                        query.and(this.eq("is_error", 1L));
                        break;
                    }
                    case SUCCESS: {
                        query.and(this.eq("is_error", 0L));
                    }
                }
                switch (condition.getQueryOrder()) {
                    case BY_START_TIME: {
                        query.setOrderBy(new AbstractQuery.OrderBy("start_time", AbstractQuery.Sort.DESC));
                        break;
                    }
                    case BY_DURATION: {
                        query.setOrderBy(new AbstractQuery.OrderBy("latency", AbstractQuery.Sort.DESC));
                    }
                }
                List tags = condition.getTags();
                if (CollectionUtils.isNotEmpty((List)tags)) {
                    ArrayList<String> tagsConditions = new ArrayList<String>(tags.size());
                    for (Tag tag : tags) {
                        tagsConditions.add(tag.toString());
                    }
                    query.and(this.having("tags", tagsConditions));
                }
                PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(condition.getPaging());
                query.setLimit(page.getLimit());
                query.setOffset(page.getFrom());
            }
        };
        TimestampRange timestampRange = this.getTimestampRange(duration);
        TraceQueryResponse resp = this.queryTraceDebuggable(isColdStage, "segment", timestampRange, query);
        ArrayList traces = new ArrayList();
        for (BanyandbTrace.Trace t : resp.getTraces()) {
            ArrayList<SpanWrapper> trace = new ArrayList<SpanWrapper>();
            for (BanyandbTrace.Span span : t.getSpansList()) {
                trace.add(SpanWrapper.parseFrom((ByteString)span.getSpan()));
            }
            traces.add(trace);
        }
        return new TracesQueryResult(traces, new RetrievedTimeRange(timestampRange.getBegin(), timestampRange.getEnd()));
    }

    private List<SegmentRecord> buildRecords(TraceQueryResponse resp, @Nullable List<String> segmentIdList, @Nullable List<String> instanceIdList, boolean filterBySegmentId) throws IOException {
        ArrayList<SegmentRecord> segmentRecords = new ArrayList<SegmentRecord>();
        for (BanyandbTrace.Trace t : resp.getTraces()) {
            for (BanyandbTrace.Span wrapper : t.getSpansList()) {
                SpanWrapper spanWrapper = SpanWrapper.parseFrom((ByteString)wrapper.getSpan());
                if (!spanWrapper.getSource().equals((Object)Source.SKYWALKING)) continue;
                SegmentObject segmentObject = SegmentObject.parseFrom((ByteString)spanWrapper.getSpan());
                SegmentRecord segmentRecord = new SegmentRecord();
                if (filterBySegmentId && (segmentIdList == null || !segmentIdList.contains(segmentObject.getTraceSegmentId()))) continue;
                segmentRecord.setSegmentId(segmentObject.getTraceSegmentId());
                segmentRecord.setTraceId(segmentObject.getTraceId());
                String serviceName = "";
                String instanceName = "";
                String endpointName = "";
                serviceName = this.getNamingControl().formatServiceName(segmentObject.getService());
                instanceName = this.getNamingControl().formatInstanceName(segmentObject.getServiceInstance());
                String serviceId = IDManager.ServiceID.buildId((String)serviceName, (boolean)true);
                segmentRecord.setServiceId(serviceId);
                String serviceInstanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)instanceName);
                if (!filterBySegmentId && (instanceIdList == null || !instanceIdList.contains(serviceInstanceId))) continue;
                segmentRecord.setServiceInstanceId(serviceInstanceId);
                long startTimestamp = 0L;
                long endTimestamp = 0L;
                for (SpanObject span : segmentObject.getSpansList()) {
                    if (startTimestamp == 0L || startTimestamp > span.getStartTime()) {
                        startTimestamp = span.getStartTime();
                    }
                    if (span.getEndTime() > endTimestamp) {
                        endTimestamp = span.getEndTime();
                    }
                    if (span.getSpanId() == 0) {
                        endpointName = this.getNamingControl().formatEndpointName(serviceName, span.getOperationName());
                    }
                    if (!SpanType.Entry.equals((Object)span.getSpanType())) continue;
                    endpointName = this.getNamingControl().formatEndpointName(serviceName, span.getOperationName());
                }
                String endpointId = IDManager.EndpointID.buildId((String)serviceId, (String)endpointName);
                segmentRecord.setEndpointId(endpointId);
                long accurateDuration = endTimestamp - startTimestamp;
                int duration = accurateDuration > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)accurateDuration;
                segmentRecord.setLatency(duration);
                segmentRecord.setStartTime(startTimestamp);
                segmentRecord.setDataBinary(spanWrapper.getSpan().toByteArray());
                segmentRecords.add(segmentRecord);
            }
        }
        return segmentRecords;
    }

    private NamingControl getNamingControl() {
        if (this.namingControl == null) {
            this.namingControl = (NamingControl)this.moduleManager.find("core").provider().getService(NamingControl.class);
        }
        return this.namingControl;
    }
}

