/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.FetchingConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigTable;
import org.apache.skywalking.oap.server.configuration.etcd.EtcdConfigException;
import org.apache.skywalking.oap.server.configuration.etcd.EtcdServerSettings;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdConfigWatcherRegister
extends FetchingConfigWatcherRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdConfigWatcherRegister.class);
    private final KV client;

    public EtcdConfigWatcherRegister(EtcdServerSettings setting) {
        super((long)setting.getPeriod());
        ClientBuilder builder = Client.builder().authority(setting.getAuthority()).target(setting.getEndpoints());
        if (StringUtil.isNotEmpty((String)setting.getNamespace())) {
            builder.namespace(ByteSequence.from((String)setting.getNamespace(), (Charset)Charset.defaultCharset()));
        }
        if (setting.isAuthentication()) {
            builder.user(ByteSequence.from((String)setting.getUser(), (Charset)Charset.defaultCharset())).password(ByteSequence.from((String)setting.getPassword(), (Charset)Charset.defaultCharset()));
        }
        this.client = builder.build().getKVClient();
    }

    public Optional<ConfigTable> readConfig(Set<String> keys) {
        ConfigTable table = new ConfigTable();
        keys.forEach(e -> {
            try {
                GetResponse response = (GetResponse)this.client.get(ByteSequence.from((String)e, (Charset)Charset.defaultCharset())).get();
                if (0L == response.getCount()) {
                    table.add(new ConfigTable.ConfigItem(e, null));
                } else {
                    response.getKvs().forEach(kv -> table.add(new ConfigTable.ConfigItem(kv.getKey().toString(Charset.defaultCharset()), kv.getValue().toString(Charset.defaultCharset()))));
                }
            }
            catch (Exception exp) {
                throw new EtcdConfigException("Failed to read configuration", exp);
            }
        });
        return Optional.of(table);
    }

    public Optional<GroupConfigTable> readGroupConfig(Set<String> keys) {
        GroupConfigTable groupConfigTable = new GroupConfigTable();
        keys.forEach(key -> {
            GroupConfigTable.GroupConfigItems groupConfigItems = new GroupConfigTable.GroupConfigItems(key);
            groupConfigTable.addGroupConfigItems(groupConfigItems);
            String groupKey = key + "/";
            GetOption option = GetOption.newBuilder().withPrefix(ByteSequence.from((String)groupKey, (Charset)Charset.defaultCharset())).build();
            try {
                List groupItemKeys;
                GetResponse response = (GetResponse)this.client.get(ByteSequence.from((String)groupKey, (Charset)Charset.defaultCharset()), option).get();
                if (0L != response.getCount() && (groupItemKeys = response.getKvs()) != null) {
                    groupItemKeys.forEach(groupItem -> {
                        String groupItemKey = groupItem.getKey().toString(Charset.defaultCharset());
                        if (!groupKey.equals(groupItemKey)) {
                            String itemValue = groupItem.getValue().toString(Charset.defaultCharset());
                            String itemName = groupItemKey.substring(groupKey.length());
                            groupConfigItems.add(new ConfigTable.ConfigItem(itemName, itemValue));
                        }
                    });
                }
            }
            catch (Exception exp) {
                throw new EtcdConfigException("Failed to read configuration", exp);
            }
        });
        return Optional.of(groupConfigTable);
    }
}

