/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util.prometheus.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Metric;

public class Summary
extends Metric {
    private long sampleCount;
    private double sampleSum;
    private final Map<Double, Double> quantiles;

    public Summary(String name, Map<String, String> labels, long sampleCount, double sampleSum, Map<Double, Double> quantiles, long timestamp) {
        super(name, labels, timestamp);
        this.getLabels().remove("quantile");
        this.sampleCount = sampleCount;
        this.sampleSum = sampleSum;
        this.quantiles = quantiles;
    }

    @Override
    public Metric sum(Metric m) {
        Summary s = (Summary)m;
        this.sampleCount += s.getSampleCount();
        this.sampleSum += s.getSampleSum();
        return this;
    }

    @Override
    public Double value() {
        return this.getSampleSum() * 1000.0 / (double)this.getSampleCount();
    }

    @Generated
    public static SummaryBuilder builder() {
        return new SummaryBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Summary)) {
            return false;
        }
        Summary other = (Summary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSampleCount() != other.getSampleCount()) {
            return false;
        }
        if (Double.compare(this.getSampleSum(), other.getSampleSum()) != 0) {
            return false;
        }
        Map<Double, Double> this$quantiles = this.getQuantiles();
        Map<Double, Double> other$quantiles = other.getQuantiles();
        return !(this$quantiles == null ? other$quantiles != null : !((Object)this$quantiles).equals(other$quantiles));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Summary;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $sampleCount = this.getSampleCount();
        result = result * 59 + (int)($sampleCount >>> 32 ^ $sampleCount);
        long $sampleSum = Double.doubleToLongBits(this.getSampleSum());
        result = result * 59 + (int)($sampleSum >>> 32 ^ $sampleSum);
        Map<Double, Double> $quantiles = this.getQuantiles();
        result = result * 59 + ($quantiles == null ? 43 : ((Object)$quantiles).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Summary(super=" + super.toString() + ", sampleCount=" + this.getSampleCount() + ", sampleSum=" + this.getSampleSum() + ", quantiles=" + String.valueOf(this.getQuantiles()) + ")";
    }

    @Generated
    public long getSampleCount() {
        return this.sampleCount;
    }

    @Generated
    public double getSampleSum() {
        return this.sampleSum;
    }

    @Generated
    public Map<Double, Double> getQuantiles() {
        return this.quantiles;
    }

    @Generated
    public static class SummaryBuilder {
        @Generated
        private String name;
        @Generated
        private ArrayList<String> labels$key;
        @Generated
        private ArrayList<String> labels$value;
        @Generated
        private long sampleCount;
        @Generated
        private double sampleSum;
        @Generated
        private ArrayList<Double> quantiles$key;
        @Generated
        private ArrayList<Double> quantiles$value;
        @Generated
        private long timestamp;

        @Generated
        SummaryBuilder() {
        }

        @Generated
        public SummaryBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public SummaryBuilder label(String labelKey, String labelValue) {
            if (this.labels$key == null) {
                this.labels$key = new ArrayList();
                this.labels$value = new ArrayList();
            }
            this.labels$key.add(labelKey);
            this.labels$value.add(labelValue);
            return this;
        }

        @Generated
        public SummaryBuilder labels(Map<? extends String, ? extends String> labels) {
            if (labels == null) {
                throw new NullPointerException("labels cannot be null");
            }
            if (this.labels$key == null) {
                this.labels$key = new ArrayList();
                this.labels$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : labels.entrySet()) {
                this.labels$key.add($lombokEntry.getKey());
                this.labels$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public SummaryBuilder clearLabels() {
            if (this.labels$key != null) {
                this.labels$key.clear();
                this.labels$value.clear();
            }
            return this;
        }

        @Generated
        public SummaryBuilder sampleCount(long sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        @Generated
        public SummaryBuilder sampleSum(double sampleSum) {
            this.sampleSum = sampleSum;
            return this;
        }

        @Generated
        public SummaryBuilder quantile(Double quantileKey, Double quantileValue) {
            if (this.quantiles$key == null) {
                this.quantiles$key = new ArrayList();
                this.quantiles$value = new ArrayList();
            }
            this.quantiles$key.add(quantileKey);
            this.quantiles$value.add(quantileValue);
            return this;
        }

        @Generated
        public SummaryBuilder quantiles(Map<? extends Double, ? extends Double> quantiles) {
            if (quantiles == null) {
                throw new NullPointerException("quantiles cannot be null");
            }
            if (this.quantiles$key == null) {
                this.quantiles$key = new ArrayList();
                this.quantiles$value = new ArrayList();
            }
            for (Map.Entry<? extends Double, ? extends Double> $lombokEntry : quantiles.entrySet()) {
                this.quantiles$key.add($lombokEntry.getKey());
                this.quantiles$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public SummaryBuilder clearQuantiles() {
            if (this.quantiles$key != null) {
                this.quantiles$key.clear();
                this.quantiles$value.clear();
            }
            return this;
        }

        @Generated
        public SummaryBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public Summary build() {
            Map<Double, Double> quantiles;
            Map<String, String> labels;
            switch (this.labels$key == null ? 0 : this.labels$key.size()) {
                case 0: {
                    labels = Collections.emptyMap();
                    break;
                }
                case 1: {
                    labels = Collections.singletonMap(this.labels$key.get(0), this.labels$value.get(0));
                    break;
                }
                default: {
                    labels = new LinkedHashMap(this.labels$key.size() < 0x40000000 ? 1 + this.labels$key.size() + (this.labels$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.labels$key.size(); ++$i) {
                        labels.put(this.labels$key.get($i), this.labels$value.get($i));
                    }
                    labels = Collections.unmodifiableMap(labels);
                }
            }
            switch (this.quantiles$key == null ? 0 : this.quantiles$key.size()) {
                case 0: {
                    quantiles = Collections.emptyMap();
                    break;
                }
                case 1: {
                    quantiles = Collections.singletonMap(this.quantiles$key.get(0), this.quantiles$value.get(0));
                    break;
                }
                default: {
                    quantiles = new LinkedHashMap(this.quantiles$key.size() < 0x40000000 ? 1 + this.quantiles$key.size() + (this.quantiles$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.quantiles$key.size(); ++$i) {
                        quantiles.put(this.quantiles$key.get($i), this.quantiles$value.get($i));
                    }
                    quantiles = Collections.unmodifiableMap(quantiles);
                }
            }
            return new Summary(this.name, labels, this.sampleCount, this.sampleSum, quantiles, this.timestamp);
        }

        @Generated
        public String toString() {
            return "Summary.SummaryBuilder(name=" + this.name + ", labels$key=" + String.valueOf(this.labels$key) + ", labels$value=" + String.valueOf(this.labels$value) + ", sampleCount=" + this.sampleCount + ", sampleSum=" + this.sampleSum + ", quantiles$key=" + String.valueOf(this.quantiles$key) + ", quantiles$value=" + String.valueOf(this.quantiles$value) + ", timestamp=" + this.timestamp + ")";
        }
    }
}

