/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum ServiceEntryLocation {
    MESH_EXTERNAL(0),
    MESH_INTERNAL(1);

    private final Integer value;
    private static final Map<Integer, ServiceEntryLocation> CONSTANTS;
    private static final Map<String, ServiceEntryLocation> NAME_CONSTANTS;

    private ServiceEntryLocation(Integer value) {
        this.value = value;
    }

    @JsonCreator
    public static ServiceEntryLocation fromValue(Object value) {
        if (value instanceof String) {
            ServiceEntryLocation constant = NAME_CONSTANTS.get(((String)value).toLowerCase());
            if (constant == null) {
                throw new IllegalArgumentException(value + "");
            }
            return constant;
        }
        ServiceEntryLocation constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value + "");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, ServiceEntryLocation>();
        NAME_CONSTANTS = new HashMap<String, ServiceEntryLocation>();
        for (ServiceEntryLocation c : ServiceEntryLocation.values()) {
            CONSTANTS.put(c.value, c);
        }
        for (ServiceEntryLocation c : ServiceEntryLocation.values()) {
            NAME_CONSTANTS.put(c.name().toLowerCase(), c);
        }
    }
}

