/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.AsyncLoader;
import com.linecorp.armeria.common.util.DefaultAsyncLoader;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

@UnstableApi
public final class AsyncLoaderBuilder<T> {
    private final Function<@Nullable T, CompletableFuture<T>> loader;
    @Nullable
    private Duration expireAfterLoad;
    @Nullable
    private Predicate<? super T> expireIf;
    @Nullable
    private Predicate<? super T> refreshIf;
    @Nullable
    private @Nullable BiFunction<? super Throwable, ? super @Nullable T, ? extends @Nullable CompletableFuture<T>> exceptionHandler;

    AsyncLoaderBuilder(Function<@Nullable T, CompletableFuture<T>> loader) {
        Objects.requireNonNull(loader, "loader");
        this.loader = loader;
    }

    public AsyncLoaderBuilder<T> expireAfterLoad(Duration expireAfterLoad) {
        Objects.requireNonNull(expireAfterLoad, "expireAfterLoad");
        Preconditions.checkState(!expireAfterLoad.isNegative(), "expireAfterLoad: %s (expected: >= 0)", expireAfterLoad);
        this.expireAfterLoad = expireAfterLoad;
        return this;
    }

    public AsyncLoaderBuilder<T> expireAfterLoadMillis(long expireAfterLoadMillis) {
        Preconditions.checkState(expireAfterLoadMillis >= 0L, "expireAfterLoadMillis: %s (expected: >= 0)", expireAfterLoadMillis);
        this.expireAfterLoad = Duration.ofMillis(expireAfterLoadMillis);
        return this;
    }

    public AsyncLoaderBuilder<T> expireIf(Predicate<? super T> expireIf) {
        Objects.requireNonNull(expireIf, "expireIf");
        this.expireIf = expireIf;
        return this;
    }

    public AsyncLoaderBuilder<T> refreshIf(Predicate<? super T> refreshIf) {
        Objects.requireNonNull(refreshIf, "refreshIf");
        this.refreshIf = refreshIf;
        return this;
    }

    public AsyncLoaderBuilder<T> exceptionHandler(BiFunction<? super Throwable, ? super @Nullable T, ? extends @Nullable CompletableFuture<T>> exceptionHandler) {
        Objects.requireNonNull(exceptionHandler, "exceptionHandler");
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public AsyncLoader<T> build() {
        return new DefaultAsyncLoader<T>(this.loader, this.expireAfterLoad, this.expireIf, this.refreshIf, this.exceptionHandler);
    }
}

