/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.reflections;

import com.linecorp.armeria.internal.shaded.guava.base.Predicate;
import com.linecorp.armeria.internal.shaded.guava.base.Predicates;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.internal.shaded.reflections.Reflections;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionsException;
import com.linecorp.armeria.internal.shaded.reflections.util.ClasspathHelper;
import com.linecorp.armeria.internal.shaded.reflections.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class ReflectionUtils {
    public static boolean includeObject = false;
    private static List<String> primitiveNames;
    private static List<Class> primitiveTypes;
    private static List<String> primitiveDescriptors;

    public static Set<Class<?>> getAllSuperTypes(Class<?> type, Predicate<? super Class<?>> ... predicates) {
        LinkedHashSet<Class<?>> result = Sets.newLinkedHashSet();
        if (type != null && (includeObject || !type.equals(Object.class))) {
            result.add(type);
            for (Class<?> supertype : ReflectionUtils.getSuperTypes(type)) {
                result.addAll(ReflectionUtils.getAllSuperTypes(supertype, new Predicate[0]));
            }
        }
        return ReflectionUtils.filter(result, predicates);
    }

    public static Set<Class<?>> getSuperTypes(Class<?> type) {
        LinkedHashSet result = new LinkedHashSet();
        Class<?> superclass = type.getSuperclass();
        Class<?>[] interfaces = type.getInterfaces();
        if (superclass != null && (includeObject || !superclass.equals(Object.class))) {
            result.add(superclass);
        }
        if (interfaces != null && interfaces.length > 0) {
            result.addAll(Arrays.asList(interfaces));
        }
        return result;
    }

    public static Set<Method> getAllMethods(Class<?> type, Predicate<? super Method> ... predicates) {
        HashSet<Method> result = Sets.newHashSet();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type, new Predicate[0])) {
            result.addAll(ReflectionUtils.getMethods(t, predicates));
        }
        return result;
    }

    public static Set<Method> getMethods(Class<?> t, Predicate<? super Method> ... predicates) {
        return ReflectionUtils.filter(t.isInterface() ? t.getMethods() : t.getDeclaredMethods(), predicates);
    }

    public static Set<Constructor> getAllConstructors(Class<?> type, Predicate<? super Constructor> ... predicates) {
        HashSet<Constructor> result = Sets.newHashSet();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type, new Predicate[0])) {
            result.addAll(ReflectionUtils.getConstructors(t, predicates));
        }
        return result;
    }

    public static Set<Constructor> getConstructors(Class<?> t, Predicate<? super Constructor> ... predicates) {
        return ReflectionUtils.filter(t.getDeclaredConstructors(), predicates);
    }

    public static Set<Field> getAllFields(Class<?> type, Predicate<? super Field> ... predicates) {
        HashSet<Field> result = Sets.newHashSet();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type, new Predicate[0])) {
            result.addAll(ReflectionUtils.getFields(t, predicates));
        }
        return result;
    }

    public static Set<Field> getFields(Class<?> type, Predicate<? super Field> ... predicates) {
        return ReflectionUtils.filter(type.getDeclaredFields(), predicates);
    }

    public static <T extends Member> Predicate<T> withName(final String name) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input) {
                return input != null && input.getName().equals(name);
            }
        };
    }

    public static Predicate<Member> withParametersCount(final int count) {
        return new Predicate<Member>(){

            @Override
            public boolean apply(@Nullable Member input) {
                return input != null && ReflectionUtils.parameterTypes(input).length == count;
            }
        };
    }

    public static <T extends Member> Predicate<T> withModifier(final int mod) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input) {
                return input != null && (input.getModifiers() & mod) != 0;
            }
        };
    }

    public static Class<?> forName(String typeName, ClassLoader ... classLoaders) {
        String type;
        if (ReflectionUtils.getPrimitiveNames().contains(typeName)) {
            return ReflectionUtils.getPrimitiveTypes().get(ReflectionUtils.getPrimitiveNames().indexOf(typeName));
        }
        if (typeName.contains("[")) {
            int i = typeName.indexOf("[");
            type = typeName.substring(0, i);
            String array = typeName.substring(i).replace("]", "");
            type = ReflectionUtils.getPrimitiveNames().contains(type) ? ReflectionUtils.getPrimitiveDescriptors().get(ReflectionUtils.getPrimitiveNames().indexOf(type)) : "L" + type + ";";
            type = array + type;
        } else {
            type = typeName;
        }
        ArrayList<ReflectionsException> reflectionsExceptions = Lists.newArrayList();
        for (ClassLoader classLoader : ClasspathHelper.classLoaders(classLoaders)) {
            if (type.contains("[")) {
                try {
                    return Class.forName(type, false, classLoader);
                }
                catch (Throwable e) {
                    reflectionsExceptions.add(new ReflectionsException("could not get type for name " + typeName, e));
                }
            }
            try {
                return classLoader.loadClass(type);
            }
            catch (Throwable e) {
                reflectionsExceptions.add(new ReflectionsException("could not get type for name " + typeName, e));
            }
        }
        if (Reflections.log != null) {
            for (ReflectionsException reflectionsException : reflectionsExceptions) {
                Reflections.log.warn("could not get type for name " + typeName + " from any class loader", reflectionsException);
            }
        }
        return null;
    }

    private static Class[] parameterTypes(Member member) {
        return member != null ? (member.getClass() == Method.class ? ((Method)member).getParameterTypes() : (member.getClass() == Constructor.class ? ((Constructor)member).getParameterTypes() : null)) : null;
    }

    private static void initPrimitives() {
        if (primitiveNames == null) {
            primitiveNames = Lists.newArrayList("boolean", "char", "byte", "short", "int", "long", "float", "double", "void");
            primitiveTypes = Lists.newArrayList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE);
            primitiveDescriptors = Lists.newArrayList("Z", "C", "B", "S", "I", "J", "F", "D", "V");
        }
    }

    private static List<String> getPrimitiveNames() {
        ReflectionUtils.initPrimitives();
        return primitiveNames;
    }

    private static List<Class> getPrimitiveTypes() {
        ReflectionUtils.initPrimitives();
        return primitiveTypes;
    }

    private static List<String> getPrimitiveDescriptors() {
        ReflectionUtils.initPrimitives();
        return primitiveDescriptors;
    }

    static <T> Set<T> filter(T[] elements, Predicate<? super T> ... predicates) {
        return Utils.isEmpty(predicates) ? Sets.newHashSet(elements) : Sets.newHashSet(Iterables.filter(Arrays.asList(elements), Predicates.and(predicates)));
    }

    static <T> Set<T> filter(Iterable<T> elements, Predicate<? super T> ... predicates) {
        return Utils.isEmpty(predicates) ? Sets.newHashSet(elements) : Sets.newHashSet(Iterables.filter(elements, Predicates.and(predicates)));
    }
}

