/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.concurrent.TimeUnit;

public final class TimeoutHeaderUtil {
    public static String toHeaderValue(long timeoutNanos) {
        long cutoff = 100000000L;
        if (timeoutNanos < 0L) {
            throw new IllegalArgumentException("Timeout too small");
        }
        if (timeoutNanos < 100000000L) {
            return TimeUnit.NANOSECONDS.toNanos(timeoutNanos) + "n";
        }
        if (timeoutNanos < 100000000000L) {
            return TimeUnit.NANOSECONDS.toMicros(timeoutNanos) + "u";
        }
        if (timeoutNanos < 100000000000000L) {
            return TimeUnit.NANOSECONDS.toMillis(timeoutNanos) + "m";
        }
        if (timeoutNanos < 100000000000000000L) {
            return TimeUnit.NANOSECONDS.toSeconds(timeoutNanos) + "S";
        }
        if (timeoutNanos < 6000000000000000000L) {
            return TimeUnit.NANOSECONDS.toMinutes(timeoutNanos) + "M";
        }
        return TimeUnit.NANOSECONDS.toHours(timeoutNanos) + "H";
    }

    public static long fromHeaderValue(String serialized) {
        Preconditions.checkArgument((!serialized.isEmpty() ? 1 : 0) != 0, (Object)"empty timeout");
        Preconditions.checkArgument((serialized.length() <= 9 ? 1 : 0) != 0, (Object)"bad timeout format");
        long value = Long.parseLong(serialized.substring(0, serialized.length() - 1));
        char unit = serialized.charAt(serialized.length() - 1);
        switch (unit) {
            case 'n': {
                return TimeUnit.NANOSECONDS.toNanos(value);
            }
            case 'u': {
                return TimeUnit.MICROSECONDS.toNanos(value);
            }
            case 'm': {
                return TimeUnit.MILLISECONDS.toNanos(value);
            }
            case 'S': {
                return TimeUnit.SECONDS.toNanos(value);
            }
            case 'M': {
                return TimeUnit.MINUTES.toNanos(value);
            }
            case 'H': {
                return TimeUnit.HOURS.toNanos(value);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid timeout unit: %s", Character.valueOf(unit)));
    }

    private TimeoutHeaderUtil() {
    }
}

