/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt.parser;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oal.rt.parser.Argument;
import org.apache.skywalking.oal.rt.parser.Expression;
import org.apache.skywalking.oal.rt.util.ClassMethodUtil;
import org.apache.skywalking.oal.rt.util.TypeCastUtil;

public class EntryMethod {
    static final int LITERAL_TYPE = 1;
    static final int ATTRIBUTE_EXP_TYPE = 2;
    static final int EXPRESSION_TYPE = 3;
    private String methodName;
    private List<Integer> argTypes = new ArrayList<Integer>();
    private List<Object> argsExpressions = new ArrayList<Object>();

    void addArg(Class<?> parameterType, Argument arg) {
        if (arg.getType() == 1) {
            this.addArg(parameterType, arg.getType(), arg.getText().get(0));
            return;
        }
        this.addArg(parameterType, arg.getType(), parameterType.equals(Boolean.TYPE) ? TypeCastUtil.withCast(arg.getCastType(), "source." + ClassMethodUtil.toIsMethod(arg.getText())) : TypeCastUtil.withCast(arg.getCastType(), "source." + ClassMethodUtil.toGetMethod(arg.getText())));
    }

    void addArg(Class<?> parameterType, String expression) {
        this.addArg(parameterType, 1, expression);
    }

    void addArg(Expression expression) {
        this.argTypes.add(3);
        this.argsExpressions.add(expression);
    }

    private void addArg(Class<?> parameterType, int type, String expression) {
        if (parameterType.equals(Integer.TYPE)) {
            expression = "(int)(" + (String)expression + ")";
        } else if (parameterType.equals(Long.TYPE)) {
            expression = "(long)(" + (String)expression + ")";
        } else if (parameterType.equals(Double.TYPE)) {
            expression = "(double)(" + (String)expression + ")";
        } else if (parameterType.equals(Float.TYPE)) {
            expression = "(float)(" + (String)expression + ")";
        }
        this.argTypes.add(type);
        this.argsExpressions.add(expression);
    }

    @Generated
    public String getMethodName() {
        return this.methodName;
    }

    @Generated
    public List<Integer> getArgTypes() {
        return this.argTypes;
    }

    @Generated
    public List<Object> getArgsExpressions() {
        return this.argsExpressions;
    }

    @Generated
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Generated
    public void setArgTypes(List<Integer> argTypes) {
        this.argTypes = argTypes;
    }

    @Generated
    public void setArgsExpressions(List<Object> argsExpressions) {
        this.argsExpressions = argsExpressions;
    }
}

