/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.client.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.healthcheck.DelegatedHealthChecker;
import org.apache.skywalking.oap.server.library.client.healthcheck.HealthCheckable;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCClient
implements Client,
HealthCheckable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GRPCClient.class);
    private final String host;
    private final int port;
    private SslContext sslContext;
    private ManagedChannel channel;
    private final DelegatedHealthChecker healthChecker = new DelegatedHealthChecker();
    private ScheduledExecutorService healthCheckExecutor;
    private boolean enableHealthCheck = false;
    private long initialDelay = 5L;
    private long period = 20L;
    private Runnable healthCheckRunnable = () -> {
        block6: {
            if (this.getChannel() != null && !this.getChannel().isShutdown()) {
                HealthGrpc.HealthBlockingStub healthStub = HealthGrpc.newBlockingStub((Channel)this.getChannel());
                HealthCheckRequest request = HealthCheckRequest.newBuilder().setService("").build();
                try {
                    HealthCheckResponse response = healthStub.check(request);
                    this.handleStateChange(response);
                }
                catch (StatusRuntimeException s) {
                    if (s.getStatus().getCode() == Status.Code.UNIMPLEMENTED) {
                        log.warn("Health check is not implemented on the remote gRPC server, regard as healthy. Host: {}, Port: {}", (Object)this.getHost(), (Object)this.getPort());
                        this.healthChecker.health();
                        break block6;
                    }
                    log.warn("Health check failed for gRPC channel. Host: {}, Port: {}", new Object[]{this.getHost(), this.getPort(), s});
                    this.healthChecker.unHealth(s);
                }
                catch (Throwable t) {
                    log.warn("Health check failed for gRPC channel. Host: {}, Port: {}", new Object[]{this.getHost(), this.getPort(), t});
                    this.healthChecker.unHealth(t);
                }
            } else {
                this.healthChecker.unHealth("gRPC channel is not available or shutting down. Host: " + this.getHost() + ", Port: " + this.getPort());
            }
        }
    };

    public GRPCClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public GRPCClient(String host, int port, SslContext sslContext) {
        this(host, port);
        this.sslContext = sslContext;
    }

    @Override
    public void connect() {
        this.channel = this.sslContext == null ? ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext().build() : NettyChannelBuilder.forAddress((String)this.host, (int)this.port).sslContext(this.sslContext).build();
        if (this.enableHealthCheck) {
            this.checkHealth();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.channel.shutdownNow();
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        finally {
            if (this.healthCheckExecutor != null) {
                this.healthCheckExecutor.shutdownNow();
                this.healthChecker.unHealth("gRPC channel is shutting down. Host: " + this.host + ", Port: " + this.port);
                this.healthCheckExecutor = null;
            }
        }
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    @Override
    public void registerChecker(HealthChecker healthChecker) {
        this.healthChecker.register(healthChecker);
        this.enableHealthCheck = true;
    }

    public void overrideCheckerRunnable(Runnable healthCheckRunnable, long initialDelay, long period) {
        this.healthCheckRunnable = healthCheckRunnable;
        if (initialDelay < 0L) {
            throw new IllegalArgumentException("initialDelay must be non-negative. Provided value: " + initialDelay);
        }
        if (period < 0L) {
            throw new IllegalArgumentException("period must be non-negative. Provided value: " + period);
        }
        this.initialDelay = initialDelay;
        this.period = period;
    }

    private void checkHealth() {
        if (this.healthCheckExecutor == null) {
            this.healthCheckExecutor = Executors.newSingleThreadScheduledExecutor();
            this.healthCheckExecutor.scheduleAtFixedRate(this.healthCheckRunnable, this.initialDelay, this.period, TimeUnit.SECONDS);
        }
    }

    private void handleStateChange(HealthCheckResponse response) {
        switch (response.getStatus()) {
            case SERVING: {
                this.healthChecker.health();
                break;
            }
            case NOT_SERVING: {
                this.healthChecker.unHealth("Remote gRPC Server NOT_SERVING. Host: " + this.host + ", Port: " + this.port);
                break;
            }
            case SERVICE_UNKNOWN: {
                this.healthChecker.unHealth("Remote gRPC Server SERVICE_UNKNOWN. Host: " + this.host + ", Port: " + this.port);
                break;
            }
            case UNKNOWN: {
                this.healthChecker.unHealth("Remote gRPC Server UNKNOWN. Host: " + this.host + ", Port: " + this.port);
                break;
            }
            case UNRECOGNIZED: {
                this.healthChecker.unHealth("Remote gRPC Server UNRECOGNIZED. Host: " + this.host + ", Port: " + this.port);
            }
        }
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }
}

