/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.google.common.base.Strings;
import graphql.kickstart.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.skywalking.oap.query.graphql.AsyncQueryUtils;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.query.TagAutoCompleteQueryService;
import org.apache.skywalking.oap.server.core.query.TraceQueryService;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TraceQueryCondition;
import org.apache.skywalking.oap.server.core.query.input.TraceQueryConditionByName;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Trace;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class TraceQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private TraceQueryService queryService;
    private TagAutoCompleteQueryService tagQueryService;

    public TraceQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private TraceQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (TraceQueryService)this.moduleManager.find("core").provider().getService(TraceQueryService.class);
        }
        return this.queryService;
    }

    private TagAutoCompleteQueryService getTagQueryService() {
        if (this.tagQueryService == null) {
            this.tagQueryService = (TagAutoCompleteQueryService)this.moduleManager.find("core").provider().getService(TagAutoCompleteQueryService.class);
        }
        return this.tagQueryService;
    }

    public CompletableFuture<TraceBrief> queryBasicTraces(TraceQueryCondition condition, boolean debug) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("TraceQueryCondition: " + String.valueOf(condition), debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query basic traces");
            try {
                TraceBrief traceBrief = this.invokeQueryBasicTraces(condition);
                if (debug) {
                    traceBrief.setDebuggingTrace(traceContext.getExecTrace());
                }
                TraceBrief traceBrief2 = traceBrief;
                return traceBrief2;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    public CompletableFuture<TraceBrief> queryBasicTracesByName(TraceQueryConditionByName condition, boolean debug) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("TraceQueryCondition: " + String.valueOf(condition), debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query basic traces");
            try {
                TraceQueryCondition traceQueryCondition = new TraceQueryCondition();
                traceQueryCondition.setServiceId(condition.getServiceId());
                traceQueryCondition.setServiceInstanceId(condition.getServiceInstanceId());
                traceQueryCondition.setEndpointId(condition.getEndpointId());
                traceQueryCondition.setTraceId(condition.getTraceId());
                traceQueryCondition.setQueryDuration(condition.getQueryDuration());
                traceQueryCondition.setMinTraceDuration(condition.getMinTraceDuration());
                traceQueryCondition.setMaxTraceDuration(condition.getMaxTraceDuration());
                traceQueryCondition.setTraceState(condition.getTraceState());
                traceQueryCondition.setQueryOrder(condition.getQueryOrder());
                traceQueryCondition.setPaging(condition.getPaging());
                traceQueryCondition.setTags(condition.getTags());
                TraceBrief traceBrief = this.invokeQueryBasicTraces(traceQueryCondition);
                if (debug) {
                    traceBrief.setDebuggingTrace(traceContext.getExecTrace());
                }
                TraceBrief traceBrief2 = traceBrief;
                return traceBrief2;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    private TraceBrief invokeQueryBasicTraces(TraceQueryCondition condition) throws IOException {
        String traceId = "";
        if (!Strings.isNullOrEmpty((String)condition.getTraceId())) {
            traceId = condition.getTraceId();
        } else if (Objects.isNull(condition.getQueryDuration())) {
            throw new UnexpectedException("The condition must contains either queryDuration or traceId.");
        }
        int minDuration = condition.getMinTraceDuration();
        int maxDuration = condition.getMaxTraceDuration();
        String endpointId = condition.getEndpointId();
        TraceState traceState = condition.getTraceState();
        QueryOrder queryOrder = condition.getQueryOrder();
        Pagination pagination = condition.getPaging();
        return this.getQueryService().queryBasicTraces(condition.getServiceId(), condition.getServiceInstanceId(), endpointId, traceId, minDuration, maxDuration, traceState, queryOrder, pagination, condition.getQueryDuration(), condition.getTags());
    }

    public CompletableFuture<Trace> queryTrace(String traceId, @Nullable Duration duration, boolean debug) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("TraceId: " + traceId, debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query trace");
            try {
                Trace trace = this.getQueryService().queryTrace(traceId, duration);
                if (debug) {
                    trace.setDebuggingTrace(traceContext.getExecTrace());
                }
                Trace trace2 = trace;
                return trace2;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    public CompletableFuture<Trace> queryTraceFromColdStage(String traceId, Duration duration, boolean debug) {
        duration.setColdStage(true);
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("TraceId: " + traceId, debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query trace from cold stage");
            try {
                Trace trace = this.getQueryService().queryTrace(traceId, duration);
                if (debug) {
                    trace.setDebuggingTrace(traceContext.getExecTrace());
                }
                Trace trace2 = trace;
                return trace2;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    public CompletableFuture<Set<String>> queryTraceTagAutocompleteKeys(Duration queryDuration) {
        return AsyncQueryUtils.queryAsync(() -> this.getTagQueryService().queryTagAutocompleteKeys(TagType.TRACE, queryDuration));
    }

    public CompletableFuture<Set<String>> queryTraceTagAutocompleteValues(String tagKey, Duration queryDuration) {
        return AsyncQueryUtils.queryAsync(() -> this.getTagQueryService().queryTagAutocompleteValues(TagType.TRACE, tagKey, queryDuration));
    }
}

