/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.relation.instance;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.instance.ServiceInstanceRelationClientSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.instance.ServiceInstanceRelationServerSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.K8SServiceInstanceRelation;

public class K8SServiceInstanceCallRelationDispatcher
implements SourceDispatcher<K8SServiceInstanceRelation> {
    @Override
    public void dispatch(K8SServiceInstanceRelation source) {
        switch (source.getDetectPoint()) {
            case SERVER: {
                this.serverSide(source);
                break;
            }
            case CLIENT: {
                this.clientSide(source);
            }
        }
    }

    private void serverSide(K8SServiceInstanceRelation source) {
        ServiceInstanceRelationServerSideMetrics metrics = new ServiceInstanceRelationServerSideMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setSourceServiceId(source.getSourceServiceId());
        metrics.setSourceServiceInstanceId(source.getSourceServiceInstanceId());
        metrics.setDestServiceId(source.getDestServiceId());
        metrics.setDestServiceInstanceId(source.getDestServiceInstanceId());
        metrics.setEntityId(source.getEntityId());
        MetricsStreamProcessor.getInstance().in(metrics);
    }

    private void clientSide(K8SServiceInstanceRelation source) {
        ServiceInstanceRelationClientSideMetrics metrics = new ServiceInstanceRelationClientSideMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setSourceServiceId(source.getSourceServiceId());
        metrics.setSourceServiceInstanceId(source.getSourceServiceInstanceId());
        metrics.setDestServiceId(source.getDestServiceId());
        metrics.setDestServiceInstanceId(source.getDestServiceInstanceId());
        metrics.setEntityId(source.getEntityId());
        MetricsStreamProcessor.getInstance().in(metrics);
    }
}

