/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.pprof.storage;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=94, name="PprofTaskLog")
@Stream(name="pprof_task_log", scopeId=94, builder=Builder.class, processor=RecordStreamProcessor.class)
@BanyanDB.TimestampColumn(value="timestamp")
@BanyanDB.Group(streamGroup=BanyanDB.StreamGroup.RECORDS)
public class PprofTaskLogRecord
extends Record {
    public static final String INDEX_NAME = "pprof_task_log";
    public static final String TASK_ID = "task_id";
    public static final String INSTANCE_ID = "instance_id";
    public static final String OPERATION_TYPE = "operation_type";
    public static final String OPERATION_TIME = "operation_time";
    public static final String TIMESTAMP = "timestamp";
    @Column(name="task_id")
    private String taskId;
    @Column(name="instance_id")
    @BanyanDB.SeriesID(index=0)
    private String instanceId;
    @Column(name="operation_type", storageOnly=true)
    private int operationType;
    @ElasticSearch.EnableDocValues
    @Column(name="operation_time")
    private long operationTime;
    @ElasticSearch.EnableDocValues
    @Column(name="timestamp")
    private long timestamp;

    @Override
    public StorageID id() {
        return new StorageID().append(TASK_ID, this.getTaskId()).append(INSTANCE_ID, this.getInstanceId()).append(OPERATION_TYPE, this.getOperationType()).append(OPERATION_TIME, this.getOperationTime());
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public int getOperationType() {
        return this.operationType;
    }

    @Generated
    public long getOperationTime() {
        return this.operationTime;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Generated
    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    @Generated
    public void setOperationTime(long operationTime) {
        this.operationTime = operationTime;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public static class Builder
    implements StorageBuilder<PprofTaskLogRecord> {
        @Override
        public PprofTaskLogRecord storage2Entity(Convert2Entity converter) {
            PprofTaskLogRecord log = new PprofTaskLogRecord();
            log.setTaskId((String)converter.get(PprofTaskLogRecord.TASK_ID));
            log.setInstanceId((String)converter.get(PprofTaskLogRecord.INSTANCE_ID));
            log.setOperationType(((Number)converter.get(PprofTaskLogRecord.OPERATION_TYPE)).intValue());
            log.setOperationTime(((Number)converter.get(PprofTaskLogRecord.OPERATION_TIME)).longValue());
            log.setTimestamp(((Number)converter.get(PprofTaskLogRecord.TIMESTAMP)).longValue());
            log.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return log;
        }

        @Override
        public void entity2Storage(PprofTaskLogRecord storageData, Convert2Storage converter) {
            converter.accept(PprofTaskLogRecord.TASK_ID, storageData.getTaskId());
            converter.accept(PprofTaskLogRecord.INSTANCE_ID, storageData.getInstanceId());
            converter.accept(PprofTaskLogRecord.OPERATION_TYPE, storageData.getOperationType());
            converter.accept(PprofTaskLogRecord.OPERATION_TIME, storageData.getOperationTime());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(PprofTaskLogRecord.TIMESTAMP, storageData.getTimestamp());
        }
    }
}

