/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.skywalking.library.elasticsearch.requests.factory.Codec;
import org.apache.skywalking.library.elasticsearch.requests.factory.RequestFactory;
import org.apache.skywalking.library.elasticsearch.requests.factory.v6.V6RequestFactory;
import org.apache.skywalking.library.elasticsearch.requests.factory.v6.codec.V6Codec;
import org.apache.skywalking.library.elasticsearch.requests.factory.v7plus.V78RequestFactory;
import org.apache.skywalking.library.elasticsearch.requests.factory.v7plus.V7RequestFactory;
import org.apache.skywalking.library.elasticsearch.requests.factory.v7plus.V81RequestFactory;
import org.apache.skywalking.library.elasticsearch.requests.factory.v7plus.codec.V78Codec;
import org.apache.skywalking.library.elasticsearch.requests.factory.v7plus.codec.V7Codec;

public final class ElasticSearchVersion {
    private final String distribution;
    private final int major;
    private final int minor;
    private final RequestFactory requestFactory;
    private final Codec codec;
    private static final Pattern REGEX = Pattern.compile("(\\d+)\\.(\\d+).*");

    private ElasticSearchVersion(String distribution, int major, int minor) {
        this.distribution = distribution;
        this.major = major;
        this.minor = minor;
        if (distribution.equalsIgnoreCase("OpenSearch")) {
            this.requestFactory = new V81RequestFactory(this);
            this.codec = V78Codec.INSTANCE;
            return;
        }
        if (distribution.equalsIgnoreCase("ElasticSearch")) {
            if (major == 6) {
                this.requestFactory = new V6RequestFactory(this);
                this.codec = V6Codec.INSTANCE;
                return;
            }
            if (major == 7) {
                if (minor < 8) {
                    this.requestFactory = new V7RequestFactory(this);
                    this.codec = V7Codec.INSTANCE;
                } else {
                    this.requestFactory = new V78RequestFactory(this);
                    this.codec = V78Codec.INSTANCE;
                }
                return;
            }
            if (major == 8) {
                this.requestFactory = new V81RequestFactory(this);
                this.codec = V78Codec.INSTANCE;
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported version: " + String.valueOf(this));
    }

    public String toString() {
        return this.distribution + " " + this.major + "." + this.minor;
    }

    public static ElasticSearchVersion of(String distribution, String version) {
        Matcher matcher = REGEX.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Failed to parse version: " + version);
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        return new ElasticSearchVersion(distribution, major, minor);
    }

    public RequestFactory requestFactory() {
        return this.requestFactory;
    }

    public Codec codec() {
        return this.codec;
    }
}

